#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'puppet'
require 'json'
require 'open3'

class DeleteCert < EnterpriseTaskHelper
  def task(certname: nil, **_kwargs)
    if !certname || certname == 'localhost'
      certname_cmd = ['/opt/puppetlabs/bin/puppet', 'config', 'print', 'certname']
      certname = Open3.capture2e(*certname_cmd)[0].strip
    end
    locations = [
      '/etc/puppetlabs/puppet/ssl',
      '/etc/puppetlabs/puppetdb/ssl',
      '/etc/puppetlabs/ace-server/ssl',
      '/etc/puppetlabs/bolt-server/ssl',
      '/etc/puppetlabs/orchestration-services/ssl',
      '/opt/puppetlabs/server/data/console-services/certs',
      '/opt/puppetlabs/server/data/host-action-collector/ssl',
      '/opt/puppetlabs/server/data/patching-service/ssl',
      '/opt/puppetlabs/server/data/infra-assistant/ssl',
      '/opt/puppetlabs/server/data/workflow-service/ssl',
    ]
    output = ''
    locations.each do |location|
      _out, status = Open3.capture2e("test -e #{location}")
      next if !status.exitstatus.zero?
      out, status = Open3.capture2e("find #{location} -name #{certname}.* -delete")
      raise EnterpriseTaskHelper::Error.new("Failed to delete certificates at #{location} with certname #{certname}", 'puppetlabs.delete-cert/delete-cert-files-failed', 'output' => output) if !status.exitstatus.zero?
      output += out
    end
    result = { _output: output }
    result.to_json
  end
end

DeleteCert.run if __FILE__ == $PROGRAM_NAME
