#!/opt/puppetlabs/puppet/bin/ruby

require 'hocon'
require 'json'

require_relative '../files/enterprise_task_helper.rb'

class GetConfValues < EnterpriseTaskHelper
  def deep_merge(this_hash, other_hash)
    other_hash.each_pair do |current_key, other_value|
      this_value = this_hash[current_key]
      this_hash[current_key] = (this_value.is_a?(Hash) && other_value.is_a?(Hash)) ? deep_merge(this_value, other_value) : other_value
    end
    this_hash
  end

  def task(path:, keys:, **_kwargs)
    result = {}
    if keys.is_a?(String)
      keys = [keys]
    end

    raise EnterpriseTaskHelper::Error.new("Path not found: #{path}", 'puppetlabs.get-conf-values/path-not-found', 'path' => path) if !File.exist?(path)

    if File.directory?(path)
      conf = {}
      Dir["#{path}/*.conf"].each do |f|
        conf = deep_merge(conf, Hocon.load(f).to_hash)
      end
    else
      conf = Hocon.load(path)
    end
    keys.each do |k|
      result[k.to_sym] = if conf.keys.include?(k)
                           conf[k]
                         else
                           nil
                         end
    end
    result[:status] = :success
    result.to_json
  end
end

GetConfValues.run if __FILE__ == $PROGRAM_NAME
