#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class PuppetInfraConfigure < EnterpriseTaskHelper
  def task(agent_pid: nil, install: nil, **_kwargs)
    certname_cmd = ['/opt/puppetlabs/bin/puppet', 'config', 'print', 'certname']
    certname = Open3.capture2e(*certname_cmd)[0].strip

    command = ['/opt/puppetlabs/bin/puppet', 'infrastructure', 'configure', '--no-recover']
    command << "--agent-pid=#{agent_pid}" if agent_pid
    command << "--install=#{install}" if install

    output, status = Open3.capture2e(*command)
    raise EnterpriseTaskHelper::Error.new("Puppet infrastructure configure failed on host with certname #{certname}", 'puppetlabs.puppet-infra-configure/infrastructure-configure-failed', 'output' => output) if !status.exitstatus.zero?

    result = { _output: output }
    result.to_json
  end
end

PuppetInfraConfigure.run if __FILE__ == $PROGRAM_NAME
