#!/opt/puppetlabs/puppet/bin/ruby

require 'json'

require_relative '../files/enterprise_task_helper.rb'

class RegisterApplication < EnterpriseTaskHelper
  def task(application:, installed:, base_url:, license_id: nil, **_kwargs)
    registration_path = '/opt/puppetlabs/applications.json'

    application_entry = {
      application => {
        'base_url' => base_url,
        'license_id' => (license_id if license_id),
      }.compact,
    }

    begin
      current_registration = File.exist?(registration_path) ? JSON.parse(File.read(registration_path)) : {}
      if !installed
        current_registration.delete(application)
      else
        current_registration.merge!(application_entry)
      end
      File.write(registration_path, current_registration.to_json)

      result = current_registration
      result[:status] = :success
      result.to_json
    rescue StandardError => e
      raise EnterpriseTaskHelper::Error.new(
        'Error when attempting to write application entry',
        'pe.application-registration/write-error',
        'exception' => e,
      )
    end
  end
end

RegisterApplication.run if __FILE__ == $PROGRAM_NAME
