#!/opt/puppetlabs/installer/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class RunPEAdmin < EnterpriseTaskHelper
  DEFAULT_PE_CONF = '/etc/puppetlabs/enterprise/conf.d/pe.conf'

  def task(pe_tarball_dir:, pe_conf: DEFAULT_PE_CONF, profile: 'all', **_kwargs)
    command = [
      '/opt/puppetlabs/installer/bin/pe-admin',
      'local-install',
      '--format=json',
      "--pe-tarball-dir=#{pe_tarball_dir}",
      "--pe-conf=#{pe_conf}",
      "--profile=#{profile}",
    ]

    output, status = Open3.capture2e(*command)
    result = {
      command: command.join(' '),
      output: output,
      exitcode: status.exitstatus,
    }

    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        'Execution of the pe-admin command failed.',
        'puppetlabs.run-pe-admin/pe-admin-failed',
        result.merge(success: false)
      )
    end

    result.merge(success: true)
  end
end

RunPEAdmin.run if __FILE__ == $PROGRAM_NAME
