#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class RunSecondaryUpgradeScript < EnterpriseTaskHelper
  def execute_command(command, err_message, err_string)
    output, status = Open3.capture2e(*command)
    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        err_message,
        "puppetlabs.run-secondary-upgrade-script/#{err_string}",
        {
          command: command,
          output: output,
          status: status.exitstatus,
        },
      )
    end
    return [output, status]
  end

  def capture_command(command, err_message, err_string)
    output, _status = execute_command(command, err_message, err_string)
    output.strip
  end

  def task(primary:, port: 8140, **_kwargs)
    ssldir = capture_command('/opt/puppetlabs/bin/puppet config print ssldir', 'Failed ssldir lookup', 'puppet-config-print-ssldir-failed')

    upgrade_bash = "#{Dir.pwd}/upgrade.bash"
    command = [
      '/opt/puppetlabs/puppet/bin/curl',
      '--cacert',
      "#{ssldir}/certs/ca.pem",
      '--output',
      upgrade_bash,
      "https://#{primary}:#{port}/packages/current/upgrade.bash",
    ]
    execute_command(command, 'Problem invoking curl', 'curl-failed')

    command = [
      'bash',
      upgrade_bash,
    ]
    execute_command(command, 'Failed running the upgrade.bash script.', 'upgrade-bash-failed')

    {
      success: true,
    }.to_json
  end
end

RunSecondaryUpgradeScript.run if __FILE__ == $PROGRAM_NAME
