# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF FILE::READABLE: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/file/lib/puppet/functions/file/readable.rb
#
# file::readable for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:'file::readable', Puppet::Functions::InternalFunction) do
  dispatch :readable do
    scope_param
    required_param 'String', :filename
    return_type 'Boolean'
  end

  def readable(scope, filename)
    raise Puppet::Error, "file::readable is currently not supported in PE plans"
  end
end
