# frozen_string_literal: true

# Context for a plan's execution
Puppet::Functions.create_function(:plan_context) do
  # @return Context data for the plan's execution environment.
  dispatch :plan_context do
    return_type 'Hash[String, String]'
  end

  def plan_context
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING, action: 'apply_prep')
    end
    # The pe_version file should be readable by everyone, so reading the file
    # should always work.
    #
    # If somehow it does not, raise an error readable to the user to identify
    # why this function is failing
    pe_version = begin
                   File.read('/opt/puppetlabs/server/pe_version').strip
                 rescue StandardError => e
                   raise Bolt::Error.new("unable to read pe_version file to parse PE version: #{e.message}", "bolt/plan_context")
                 end
    {
      "executor" =>  "pe",
      "executor_version" => pe_version,
      "executor_host" => Puppet[:certname]
    }
  end
end
