# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

* [`pe_patch`](#pe_patch): This manifest sets up a script and cron job to populate
the `pe_patch` fact.

**Tasks**

* [`clean_cache`](#clean_cache): Clean patch caches (yum/dpkg) via a task
* [`patch_server`](#patch_server): Carry out OS patching on the server, optionally including a reboot and/or only applying security related updates
* [`refresh_fact`](#refresh_fact): Force a refresh of the pe_patch fact cache via a task

**Plans**

* [`pe_patch::group_patching`](#group_patching) Documented as part of the [standard patching workflow](https://help.puppet.com/pe/2025.5/topics/patch_management_patching_plan.htm)

## Classes

### pe_patch

This manifest sets up a script and cron job to populate
the `pe_patch` fact.

#### Examples

##### assign node to 'Week3' patching group, force a reboot and create a blackout window for the end of the year

```puppet
class { 'pe_patch':
  patch_group      => 'Week3',
  reboot_override  => 'always',
  blackout_windows => { 'End of year change freeze':
    {
      'start': '2018-12-15T00:00:00+10:00',
      'end': '2019-01-15T23:59:59+10:00',
    }
  },
}
```

##### An example profile to setup patching, sourcing blackout windows from hiera

```puppet
class profiles::soe::patching (
  $patch_group      = undef,
  $blackout_windows = undef,
  $reboot_override  = undef,
){
  # Pull any blackout windows out of hiera
  $hiera_blackout_windows = lookup('profiles::soe::patching::blackout_windows',Hash,hash,{})

  # Merge the blackout windows from the parameter and hiera
  $full_blackout_windows = $hiera_blackout_windows + $blackout_windows

  # Call the pe_patch class to set everything up
  class { 'pe_patch':
    patch_group      => $patch_group,
    reboot_override  => $reboot_override,
    blackout_windows => $full_blackout_windows,
  }
}
```

##### JSON hash to specify a change freeze from 2018-12-15 to 2019-01-15

```puppet
{"End of year change freeze": {"start": "2018-12-15T00:00:00+10:00", "end": "2019-01-15T23:59:59+10:00"}}
```

##### Run patching on the node `centos.example.com` using the smart reboot option

```puppet
puppet task run pe_patch::patch_server --params '{"reboot": "smart"}' --nodes centos.example.com
```

##### Remove from a managed system

```puppet
class { 'pe_patch':
  ensure => absent,
}
```

#### Parameters

The following parameters are available in the `pe_patch` class.

##### `patch_data_owner`

Data type: `String`

User name for the owner of the patch data

Default value: 'root'

##### `patch_data_group`

Data type: `String`

Group name for the owner of the patch data

Default value: 'root'

##### `patch_cron_user`

Data type: `String`

User who runs the cron job

Default value: $patch_data_owner

##### `manage_yum_utils`

Data type: `Boolean`

Should the yum_utils package be managed by this module on RedHat family nodes?
If `true`, use the parameter `yum_utils` to determine how it should be manged

Default value: `false`

##### `block_patching_on_warnings`

Data type: `Boolean`

If there are warnings present in the pe_patch fact, should the patching task run?
If `true` the run will abort and take no action
If `false` the run will continue and attempt to patch (default)

Default value: `false`

##### `yum_utils`

Data type: `Enum['installed', 'absent', 'purged', 'held', 'latest']`

If managed, what should the yum_utils package set to?

Default value: 'installed'

##### `fact_upload`

Data type: `Boolean`

Should `puppet fact upload` be run after any changes to the fact cache files?

Default value: `true`

##### `apt_autoremove`

Data type: `Boolean`

Should `apt-get autoremove` be run during reboot?

Default value: `false`

##### `manage_delta_rpm`

Data type: `Boolean`

Should the deltarpm package be managed by this module on RedHat family nodes?
If `true`, use the parameter `delta_rpm` to determine how it should be manged

Default value: `false`

##### `delta_rpm`

Data type: `Enum['installed', 'absent', 'purged', 'held', 'latest']`

If managed, what should the delta_rpm package set to?

Default value: 'installed'

##### `manage_yum_plugin_security`

Data type: `Boolean`

Should the yum_plugin_security package be managed by this module on RedHat family nodes?
If `true`, use the parameter `yum_plugin_security` to determine how it should be manged

Default value: `false`

##### `yum_plugin_security`

Data type: `Enum['installed', 'absent', 'purged', 'held', 'latest']`

If managed, what should the yum_plugin_security package set to?

Default value: 'installed'

##### `reboot_override`

Data type: `Optional[Variant[Boolean, Enum['always', 'never', 'patched', 'smart', 'default']]]`

Controls on a node level if a reboot should/should not be done after patching.
This overrides the setting in the task

Default value: 'default'

##### `patch_group`

Data type: `String`

A freeform text entry used to allocate a node to a specific patch group (Optional)

Default value: `undef`

##### `pre_patching_command`

Data type: `Optional[Stdlib::Absolutepath]`

The full path of the command to run prior to running patching.  Can be used to
run customised workflows such as gracefully shutting down applications.  The entry
must be a single absolute filename with no arguments or parameters.

Default value: `undef`

##### `patch_cron_hour`

Data type: `Any`

The hour(s) for the cron job to run (defaults to absent, which means '*' in cron)

Default value: absent

##### `patch_cron_month`

Data type: `Any`

The month(s) for the cron job to run (defaults to absent, which means '*' in cron)

Default value: absent

##### `patch_cron_monthday`

Data type: `Any`

The monthday(s) for the cron job to run (defaults to absent, which means '*' in cron)

Default value: absent

##### `patch_cron_weekday`

Data type: `Any`

The weekday(s) for the cron job to run (defaults to absent, which means '*' in cron)

Default value: absent

##### `patch_cron_min`

Data type: `Any`

The min(s) for the cron job to run (defaults to a random number between 0 and 59)

Default value: fqdn_rand(59)

##### `ensure`

Data type: `Enum['present', 'absent']`

`present` to install scripts, cronjobs, files, etc, `absent` to cleanup a system that previously hosted us

Default value: 'present'

##### `blackout_windows`

Data type: `Optional[Hash]`



Options:

* **:title** `String`: Name of the blackout window
* **:start** `String`: Start of the blackout window (ISO8601 format)
* **:end** `String`: End of the blackout window (ISO8601 format)

Default value: `undef`

## Tasks

### clean_cache

Clean patch caches (yum/dpkg) via a task

**Supports noop?** false

### patch_server

Carry out OS patching on the server, optionally including a reboot and/or only applying security related updates

**Supports noop?** false

#### Parameters

##### `yum_params`

Data type: `Optional[String]`

Any additional parameters to include in the yum upgrade command (such as including/excluding repos)

##### `dpkg_params`

Data type: `Optional[String]`

Any additional parameters to include in the dpkg command

##### `zypper_params`

Data type: `Optional[String]`

Any additional parameters to include in the zypper update command

##### `reboot`

Data type: `Optional[Variant[Boolean, Enum['always', 'never', 'patched', 'smart']]]`

Should the server reboot after patching has been applied? (Defaults to 'never')

##### `timeout`

Data type: `Optional[Integer]`

How many seconds should we wait until timing out the patch run? (Defaults to 3600 seconds)

##### `security_only`

Data type: `Optional[Boolean]`

Limit patches to those tagged as security related? (Defaults to false)

##### `clean_cache`

Data type: `Optional[Boolean]`

Should the yum/dpkg caches be cleaned at the start of the task? (Defaults to false)

### refresh_fact

Force a refresh of the pe_patch fact cache via a task

**Supports noop?** false

## Plans

### `group_patching`

A plan to patch nodes with pre- and post-patching health checks. The plan verifies that Puppet is configured and running correctly on target nodes, patches the nodes, waits for any reboots, and then runs Puppet on the nodes to verify that they're still operational.

#### Parameters

The following parameters are available in the `group_patching` plan.

##### patch_group

Data type: `String`

##### reboot

Data type: `Optional[Enum['always', 'never', 'patched', 'smart']]` (Defaults to never)

##### yum_params

Data type: `Optional[String]`

##### dpkg_params

Data type: `Optional[String]`

##### zypper_params

Data type: `Optional[String]`

##### patch_task_timeout

Data type: `Optional[Integer]` (Defaults to 3600)

##### health_check_runinterval

Data type: `Optional[Integer]` (Defaults to 1800)

##### reboot_wait_time

Data type: `Optional[Integer]` (Defaults to 600)

##### security_only

Data type: `Optional[Boolean]` (Defaults to false)

##### run_health_check

Data type: `Optional[Boolean]` (Defaults to true)

##### clean_cache

Data type: `Optional[Boolean]` (Defaults to false)

##### health_check_noop

Data type: `Optional[Boolean]` (Defaults to false)

##### health_check_use_cached_catalog

Data type: `Optional[Boolean]` (Defaults to false)

##### health_check_service_enabled

Data type: `Optional[Boolean]` (Defaults to true)

##### health_check_service_running

Data type: `Optional[Boolean]` (Defaults to false)

##### sequential_patching

Data type: `Optional[Boolean]` (Defaults to false)

##### post_reboot_scriptpath

Data type: Optional[Pe_patch::Absolutepath]