require 'hocon/parser/config_document_factory'
require 'hocon/config_error'
require 'hocon/config_value_factory'
require 'json'

module PeBackupTools
  module Utils
    # This module provides utility functions for the overall install command
    # Contains methods to generate/merge pe.conf content, as well as helpers for Hocon functionality
    module ConfFiles
      def self.hocon_assoc(object, key, value)
        key_quoted = "\"#{key}\""
        # rubocop:disable Style/PreferredHashMethods
        object.has_value?(key_quoted) ? object.set_config_value(key_quoted, Hocon::ConfigValueFactory.from_any_ref(value)) : object
        # rubocop:enable Style/PreferredHashMethods
      end

      def self.hocon_merge(object, hash)
        hash.each do |key, value|
          object = hocon_assoc(object, key, value)
        end
        object
      end
    end
  end
end
