# Reprovisions a replica database entirely.
#
# After stopping all PE services on the replica (except pxp-agent),
# all databases, including puppetdb, are removed and recreated by
# streaming them from primary and then reinitializing the pglogical
# dbs to resynchronize.
#
# No backup is taken.
#
# This is distinct from the `puppet-infra reinitialize` command in two ways.
# First, the reinitialize command only drops and recreates the pglogical
# managed databases, so puppetdb is not touched. Second, reinitialize must
# be run from the replica command line.
#
# The reprovision plan is a superset of reinitialize, since it includes
# reinitialize in its final step.
#
# @param replica [Variant[Target,String]] the replica node to reprovision.
# @param primary [Variant[Target,String]] the primary node.
#
# @api private
plan enterprise_tasks::reprovision_replica(
  Variant[Target,String] $replica,
  Variant[Target,String] $primary,
  Optional[Boolean] $force = false,
) {
  $replica_target = get_target($replica)
  $primary_target = get_target($primary)
  enterprise_tasks::test_connection([$primary_target, $replica_target])

  enterprise_tasks::with_agent_disabled($primary_target) || {
    enterprise_tasks::verify_node($replica_target, 'replica', $force)

    run_task('enterprise_tasks::pe_services', $replica_target,
      role => 'replica',
      state => 'stopped',
      include_puppet => false,
    )

    run_task('enterprise_tasks::pg_basebackup', $replica_target,
      primary => $primary_target.name,
    )

    run_task('enterprise_tasks::reinitialize_replica', $replica_target)
  }
}
