#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'hocon'

class GetEnterpriseData < EnterpriseTaskHelper
  def task(parse: false, **_kwargs)
    enterprise_conf_dir = '/etc/puppetlabs/enterprise/conf.d'
    files = ["#{enterprise_conf_dir}/user_data.conf", Dir.glob("#{enterprise_conf_dir}/nodes/*")].flatten
    contents = files.each_with_object({}) do |path, hash|
      next if !File.exist?(path)
      f = File.read(path)
      hash[path] = parse ?
        Hocon.parse(f) :
        f
    end
    result = { enterprise_data: contents }
    result.to_json
  end
end

GetEnterpriseData.run if __FILE__ == $PROGRAM_NAME
