module Puppet::Parser::Functions
  newfunction(:pe_formatted_date, :type => :rvalue) do |arguments|
    # Technically we support two arguments but only first is mandatory ...
    raise(Puppet::ParseError, "pe_formatted_date(): Wrong number of arguments " +
      "given (#{arguments.size} for 1)") if arguments.size < 1

    format = arguments[0]

    raise(Puppet::ParseError, 'pe_formatted_date(): You must provide ' +
      'format for evaluation') if format.empty?

    # The Time Zone argument is optional ...
    time_zone = arguments[1] if arguments[1]

    time = Time.new

    # There is probably a better way to handle Time Zone ...
    if time_zone and not time_zone.empty?
      original_zone = ENV['TZ']

      local_time = time.clone
      local_time = local_time.utc

      ENV['TZ'] = time_zone

      time = local_time.localtime

      ENV['TZ'] = original_zone
    end

    result = time.strftime(format)

    return result
  end
end
