module Puppet::Parser::Functions
  newfunction(:platform_tag_to_pe_repo_class, :type => :rvalue, :doc => <<-EOS
    Converts a given platform tag to a suitable pe_repo puppet class name.
  EOS
  ) do |args|


    if args.length != 1 then
      raise Puppet::ParseError, ("platform_tag_to_pe_repo_class(): wrong number of arguments (#{args.length}; must be 1)")
    end

    platform_tag = args[0]

    # In order to convert a platform tag to a puppet class name,
    # convert all dashes to underscores, and remove any periods.
    #
    # Example platform tags:
    # el-7-x86_64
    # ubunbu-14.04-amd64
    platform_tag.gsub(/-/, '_').gsub(/\./,'')
  end
end

