# Remove the logrotate config for all trapperkeeper-based PE services on
# upgrade from pre-2016.5.0 to 2016.5.0 or later
#
# @param upgrade_from [Optional[String]] The version of PE we are upgrading from.
class pe_install::upgrade::remove_logrotate_config_for_tk_services(
  Optional[String] $upgrade_from = $pe_install::upgrade_from,
) {
  if !pe_empty($upgrade_from) and
    (versioncmp($upgrade_from, '2016.5.0') < 0) {

    if $::pe_install::is_console {
      file { "/etc/logrotate.d/pe-console-services":
        ensure => absent
      }
    }

    if $::pe_install::is_master {
      file { "/etc/logrotate.d/pe-puppetserver":
        ensure => absent
      }
      file { "/etc/logrotate.d/pe-orchestration-services":
        ensure => absent
      }
    }

    if $::pe_install::is_puppetdb {
      file { "/etc/logrotate.d/pe-puppetdb":
        ensure => absent
      }
    }
  }
}
