Puppet::Type.newtype(:pe_postgresql_conf) do

  @doc = "This type allows puppet to manage postgresql.conf parameters."

  ensurable

  newparam(:name) do
    desc "The postgresql parameter name to manage."
    isnamevar

    newvalues(/^[\w\.]+$/)
  end

  newproperty(:value) do
    desc "The value to set for this parameter."
  end

  newproperty(:target) do
    desc "The path to postgresql.conf"
    defaultto {
      if @resource.class.defaultprovider.ancestors.include?(Puppet::Provider::ParsedFile)
        @resource.class.defaultprovider.default_target
      else
        nil
      end
    }
  end

  def flush
     # (PE-30030) Clearing the gem specifications is a workaround for PE catalogs that
     # update packages that change gems in Puppet's gempath followed by an autoload
     # (see ticket). In this particular case, the parsedfile provider used by this
     # type involves an indirector lookup of Filebucket.
    Gem.clear_paths
    super
  end
end
