require 'json'

Puppet::Functions.create_function('pe_repo::get_license') do
  dispatch :get_license do
  end

  # This function queries the license API and returns the license ID if the license type is valid.
  # If the license type is invalid or the 'type' key is not present in the response.
  #
  # @return [String] The license ID from the API response or a blank string.
  def get_license()
    ca_path = '/etc/puppetlabs/puppet/ssl/certs/ca.pem'
    return '' unless File.exist?(ca_path)
    response = call_function('pe_repo::query_license_api')

    if response.key?('type')
      unless response['type'] == 'valid'
        return ''
      else
        return response['id']
      end
    end
    return ''
  end
end