- puppet_enterprise_support.tar.gz/

  Version: 1.3

  Support script tarball. Usually named:

      puppet_enterprise_support_<hostname>_<datestamp>.tar.gz

  Where <hostname> is the short hostname of the node that the
  script was generated on and <datestamp> is generated by:

      date -u '+%Y%m%d%H%M%S'

- puppet_enterprise_support/enterprise/

  Top-level directory containing configuration files and
  diagnostics gathered from PE services

- puppet_enterprise_support/enterprise/activemq_resource_limits

  A text file containing the number of file descriptors used
  by the pe-activemq service along with the total number of
  decriptors allowed by the ulimit for the pe-activemq user.

  Only gathered on nodes where the pe-activemq package is
  installed.

- puppet_enterprise_support/enterprise/certs.txt

  A text file listing every certificate or certificate request
  known to the Puppet CA, generated by `puppet cert list -a`.

  Only gathered on nodes where the ssl/ca directory exists.

- puppet_enterprise_support/enterprise/console_status.json

  Contains the output of the /status/v1/services
  endpoint for the pe-console-services service.

  Only gathered on nodes where the pe-console-services package
  is installed.

- puppet_enterprise_support/enterprise/etc/
- puppet_enterprise_support/enterprise/etc/puppetlabs/

  Directory containing configuration files gathered from
  /etc/puppetlabs on the node where the support script
  was run.

  https://puppet.com/docs/pe/2018.1/what_gets_installed_and_where.html#configuration-files-installed

- puppet_enterprise_support/enterprise/etc/puppetlabs/activemq/
- puppet_enterprise_support/enterprise/etc/puppetlabs/activemq/activemq.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/activemq/jetty.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/activemq/log4j.properties
- puppet_enterprise_support/enterprise/etc/puppetlabs/client-tools/
- puppet_enterprise_support/enterprise/etc/puppetlabs/client-tools/orchestrator.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/client-tools/puppet-access.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/client-tools/puppet-code.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/client-tools/puppetdb.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/bootstrap.cfg
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/activity-database.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/activity.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/classifier-database.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/classifier.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/console.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/console_secret_key.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/global.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/rbac-database.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/rbac-static.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/rbac.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/conf.d/webserver.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/logback.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/rbac-certificate-whitelist
- puppet_enterprise_support/enterprise/etc/puppetlabs/console-services/request-logging.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/enterprise/
- puppet_enterprise_support/enterprise/etc/puppetlabs/enterprise/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/enterprise/conf.d/common.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/enterprise/conf.d/pe.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/enterprise/hiera.yaml
- puppet_enterprise_support/enterprise/etc/puppetlabs/mcollective/
- puppet_enterprise_support/enterprise/etc/puppetlabs/mcollective/server.cfg
- puppet_enterprise_support/enterprise/etc/puppetlabs/nginx/
- puppet_enterprise_support/enterprise/etc/puppetlabs/nginx/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/nginx/conf.d/proxy.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/nginx/nginx.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/bootstrap.cfg
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/authorization.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/global.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/metrics.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/orchestrator.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/pcp-broker.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/web-routes.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/conf.d/webserver.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/logback.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/orchestration-services/request-logging.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/peadmin/
- puppet_enterprise_support/enterprise/etc/puppetlabs/peadmin/client.cfg

  A copy of the MCO client configuartion from `/var/lib/peadmin/.mcollective`.

  Only collected if the `peadmin` user is present.

- puppet_enterprise_support/enterprise/etc/puppetlabs/postgres/
- puppet_enterprise_support/enterprise/etc/puppetlabs/postgres/pg_hba.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/postgres/pg_ident.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/postgres/postgresql.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/postgres/postmaster.opts
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/auth.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/autosign.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/fileserver.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/hiera.yaml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/puppet.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/puppetdb.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppet/routes.yaml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/bootstrap.cfg
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/certificate-whitelist
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/config.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/database.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/jetty.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/rbac_consumer.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/read_database.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/repl.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/conf.d/routing.ini
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/logback.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetdb/request-logging.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/bootstrap.cfg
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/code-manager-request-logging.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/activity-consumer.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/auth.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/ca.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/code-manager.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/file-sync.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/global.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/metrics.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/pe-puppet-server.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/rbac-consumer.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/web-routes.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/conf.d/webserver.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/logback.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/puppetserver/request-logging.xml
- puppet_enterprise_support/enterprise/etc/puppetlabs/pxp-agent/
- puppet_enterprise_support/enterprise/etc/puppetlabs/pxp-agent/modules/
- puppet_enterprise_support/enterprise/etc/puppetlabs/pxp-agent/pxp-agent.conf
- puppet_enterprise_support/enterprise/etc/puppetlabs/r10k/
- puppet_enterprise_support/enterprise/etc/puppetlabs/r10k/r10k.yaml

- puppet_enterprise_support/enterprise/find/

  Directory containing `find ... -ls` output for PE directory
  trees. Substituting `_` for `/` in the filenames will give
  the path the `find` command was run on. For example:

      _etc_puppetlabs.txt

  Contains output from:

      find /etc/puppetlabs -ls

- puppet_enterprise_support/enterprise/find/_etc_puppetlabs.txt
- puppet_enterprise_support/enterprise/find/_opt_puppetlabs.txt
- puppet_enterprise_support/enterprise/find/_var_lib_peadmin.txt
- puppet_enterprise_support/enterprise/find/_var_log_puppetlabs.txt

- puppet_enterprise_support/enterprise/mco_inventory_peadmin.txt

  Contains output from the `mco inventory <hostname>` command,
  where `<hostname>` is the hostname of the node where the
  support script was run.

  Only collected if the `peadmin` user is present.

- puppet_enterprise_support/enterprise/mco_ping_peadmin.txt

  Contains output from the `mco ping` command,

  Only collected if the `peadmin` user is present.

- puppet_enterprise_support/enterprise/modules.txt

  Contains output from the `puppet module list` command.
  Only returns modules installed in the default environment,
  usually `production`.

- puppet_enterprise_support/enterprise/orchestration_status.json

  Contains the output of the /status/v1/services
  endpoint for the pe-orchestration-services service.

  Only gathered on nodes where the pe-orchestration-services
  package is installed.

- puppet_enterprise_support/enterprise/packages.txt

  Contains the version numbers of installed PE packages, as
  reported by the system package manager (rpm, dpkg, etc.).

- puppet_enterprise_support/enterprise/postgres_settings.txt

  Contains the output of `select * from pg_settings;`.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/enterprise/puppet_gems.txt

  Contains the output of `/opt/puppetlabs/pupet/bin/gem gem list --local`.

- puppet_enterprise_support/enterprise/puppetdb_summary_stats.json

  Contains the output of the /pdb/admin/v1/summary-stats
  endpoint for the pe-puppetdb service.

  Only gathered on nodes where the pe-puppetdb package is installed.

- puppet_enterprise_support/enterprise/puppetserver_environments.json

  Contains the output of the /puppet/v3/environments
  endpoint for the pe-puppetserver service.

  Only gathered on nodes where the pe-puppetserver package
  is installed.

- puppet_enterprise_support/enterprise/puppetserver_gems.txt

  Contains the output of `puppetserver gem list --local`.

  Only gathered on nodes where the pe-puppetserver package
  is installed.

- puppet_enterprise_support/enterprise/puppetserver_status.json

  Contains the output of the /status/v1/services
  endpoint for the pe-puppetserver service.

  Only gathered on nodes where the pe-puppetserver package
  is installed.

- puppet_enterprise_support/enterprise/r10k_deploy_display.txt

  Contains the output of `r10k deploy display -p` run using
  Code Manager configuration or `/etc/puppetlabs/r10k/r10k.yaml`.

  Only gathered on nodes where `pe-r10k` is present.

- puppet_enterprise_support/enterprise/rbac_directory_settings.json

  Contains RBAC configuration, minus passwords, used to perform
  LDAP queries for adding users and groups to the console.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/enterprise/state/

  A copy of the `/opt/puppetlabs/puppet/cache/state` directory
  from the node on which the support script was run.

- puppet_enterprise_support/enterprise/state/classes.txt
- puppet_enterprise_support/enterprise/state/graphs/
- puppet_enterprise_support/enterprise/state/graphs/expanded_relationships.dot
- puppet_enterprise_support/enterprise/state/graphs/relationships.dot
- puppet_enterprise_support/enterprise/state/graphs/resources.dot
- puppet_enterprise_support/enterprise/state/last_run_report.yaml
- puppet_enterprise_support/enterprise/state/last_run_summary.yaml
- puppet_enterprise_support/enterprise/state/resources.txt
- puppet_enterprise_support/enterprise/state/state.yaml
- puppet_enterprise_support/enterprise/state/transactionstore.yaml

- puppet_enterprise_support/enterprise/thundering_herd_query.txt

  Output from a psql query showing the distribution of agent
  start times.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/etc/
- puppet_enterprise_support/etc/@hosts

  A convenience symlink to the system/etc/hosts file which
  enables hostname redaction when using the soscleaner tool.

- puppet_enterprise_support/@hostname

  A convenience symlink to the networking/hostname_output.txt
  file which allows enables hostname redaction when using the
  soscleaner tool.

- puppet_enterprise_support/logs/

  Directory containing log files gathered from /var/log/puppetlabs
  on the node where the support script was run.

  On systemd-based operating systems, `<service>-journalctl.log` files will
  be collected for each PE `<service>`.

  https://puppet.com/docs/pe/2018.1/what_gets_installed_and_where.html#log-files-installed

- puppet_enterprise_support/logs/activemq/
- puppet_enterprise_support/logs/console-services/
- puppet_enterprise_support/logs/console-services/console-services-access.log
- puppet_enterprise_support/logs/console-services/console-services-api-access.log
- puppet_enterprise_support/logs/console-services/console-services-journalctl.log
- puppet_enterprise_support/logs/console-services/console-services-status.log
- puppet_enterprise_support/logs/console-services/console-services.log
- puppet_enterprise_support/logs/installer/
- puppet_enterprise_support/logs/installer/<timestamp>.install.log
- puppet_enterprise_support/logs/mcollective-audit.log
- puppet_enterprise_support/logs/mcollective-journalctl.log
- puppet_enterprise_support/logs/mcollective-metadata-cron.log
- puppet_enterprise_support/logs/mcollective.log

- puppet_enterprise_support/logs/messages.gz

  A copy of the system log from RedHat nodes.

- puppet_enterprise_support/logs/syslog.gz

  A copy of the system log from Debian nodes.

- puppet_enterprise_support/logs/nginx/
- puppet_enterprise_support/logs/nginx/access.log
- puppet_enterprise_support/logs/nginx/error.log
- puppet_enterprise_support/logs/nginx/nginx-journalctl.log
- puppet_enterprise_support/logs/orchestration-services/
- puppet_enterprise_support/logs/orchestration-services/orchestration-services-access.log
- puppet_enterprise_support/logs/orchestration-services/orchestration-services-journalctl.log
- puppet_enterprise_support/logs/orchestration-services/orchestration-services-status.log
- puppet_enterprise_support/logs/orchestration-services/orchestration-services.log
- puppet_enterprise_support/logs/orchestration-services/pcp-broker-access.log
- puppet_enterprise_support/logs/peadmin/
- puppet_enterprise_support/logs/peadmin/client.log

  A copy of the MCO client log from `/var/lib/peadmin/.mcollective.d/`.

  Only collected if the `peadmin` user is present.

- puppet_enterprise_support/logs/postgresql/
- puppet_enterprise_support/logs/postgresql/pgstartup.log
- puppet_enterprise_support/logs/postgresql/postgresql-journalctl.log
- puppet_enterprise_support/logs/postgresql/postgresql-*.log
- puppet_enterprise_support/logs/puppet/
- puppet_enterprise_support/logs/puppet-journalctl.log
- puppet_enterprise_support/logs/puppetdb/
- puppet_enterprise_support/logs/puppetdb/puppetdb-access.log
- puppet_enterprise_support/logs/puppetdb/puppetdb-journalctl.log
- puppet_enterprise_support/logs/puppetdb/puppetdb-status.log
- puppet_enterprise_support/logs/puppetdb/puppetdb.log
- puppet_enterprise_support/logs/puppetserver/
- puppet_enterprise_support/logs/puppetserver/code-manager-access.log
- puppet_enterprise_support/logs/puppetserver/file-sync-access.log
- puppet_enterprise_support/logs/puppetserver/masterhttp.log
- puppet_enterprise_support/logs/puppetserver/puppetserver-access.log
- puppet_enterprise_support/logs/puppetserver/puppetserver-journalctl.log
- puppet_enterprise_support/logs/puppetserver/puppetserver-status.log
- puppet_enterprise_support/logs/puppetserver/puppetserver.log
- puppet_enterprise_support/logs/pxp-agent/
- puppet_enterprise_support/logs/pxp-agent/pxp-agent.log
- puppet_enterprise_support/logs/pxp-agent-journalctl.log
- puppet_enterprise_support/logs/r10k/

- puppet_enterprise_support/metadata.json

  A JSON file containing metadata about the support script
  run that generated this archive. Currently this contains
  the support script version number and the time that the
  script was run as reported by:

      date -u '+%Y%m%d%H%M%S'

- puppet_enterprise_support/networking/

  Directory containing network diagnostics gathered from
  the node where the support script was run.

- puppet_enterprise_support/networking/guessed_ip_address.txt

  Contains a guess of the IP address used when ICMP
  traffic is routed the node based on the output of `ping`.

- puppet_enterprise_support/networking/hostname_output.txt

  Contains the output of `hostname -f`.

- puppet_enterprise_support/networking/ifconfig.txt

  Contains the output of `ifconfig -a`.

- puppet_enterprise_support/networking/ip_tables.txt

  Contains the output of `iptables -L` and `ip6tables -L`.

- puppet_enterprise_support/networking/mapped_hostname_from_guessed_ip_address.txt

  Contains a guess of the hostname associated with IP address
  used when ICMP traffic is routed the node based on the
  output of `tracepath`.

- puppet_enterprise_support/networking/ports.txt

  Contains the output of `netstat -anptu`.

- puppet_enterprise_support/networking/puppet_ping.txt

  Contains the result of a `ping` test indicating whether the
  hostname returned by `puppet agent --configprint server` is
  reachable.

- puppet_enterprise_support/resources/

  Directory containing diagnostics about available disk space
  space used by PE databases, and memory on the node where the
  support script was run.

- puppet_enterprise_support/resources/db_relation_sizes.txt

  Contains the output of `psql` queries giving the size
  of tables and indices in each PE database.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/resources/db_sizes_from_du.txt

  Contains the output of `du` commands giving the actual
  disk spaced used by each PE database.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/resources/db_sizes_from_psql.txt

  Contains the output of `psql` queries giving the total
  size of each PE database.

  Only gathered on nodes where the pe-postgresql-server package
  is installed.

- puppet_enterprise_support/resources/df_inodes_output.txt

  Contains the output of `df -i`.

- puppet_enterprise_support/resources/df_output.txt

  Contains the output of `df -h`.

- puppet_enterprise_support/resources/free_mem.txt

  Contains the output of `free`.

- puppet_enterprise_support/system/

  Directory containing miscellaneous diagnostics and system
  configuration files that are relevant to the operation of
  PE services on the node where the support script was run.

- puppet_enterprise_support/system/env.txt

  Contains the output of `env`.

- puppet_enterprise_support/system/etc/

  Contains copies of various configuration files from the
  `/etc` directory. Files named after PE services are
  daemon environment files copied from `/etc/sysconfig` on
  RedHat-based systems or `/etc/defaults` on Debian-based
  systems.

- puppet_enterprise_support/system/etc/hosts

  Contains a copy of `/ect/hosts`.

- puppet_enterprise_support/system/etc/mcollective
- puppet_enterprise_support/system/etc/nsswitch.conf

  Contains a copy of `/etc/nsswitch.conf`.

- puppet_enterprise_support/system/etc/pe-activemq
- puppet_enterprise_support/system/etc/pe-console-services
- puppet_enterprise_support/system/etc/pe-nginx
- puppet_enterprise_support/system/etc/pe-orchestration-services
- puppet_enterprise_support/system/etc/pe-puppetdb
- puppet_enterprise_support/system/etc/pe-puppetserver
- puppet_enterprise_support/system/etc/puppet
- puppet_enterprise_support/system/etc/pxp-agent
- puppet_enterprise_support/system/etc/resolv.conf

  Contains a copy of `/etc/resolv.conf`.

- puppet_enterprise_support/system/facter_output.txt

  Contains the output of `puppet facts`.

- puppet_enterprise_support/system/ps_aux.txt

  Contains the output of `ps -aux`.

- puppet_enterprise_support/system/ps_tree.txt

  Contains the output of `ps -e f`.

- puppet_enterprise_support/system/selinux.txt

  Contains the output of `sestatus`.

- puppet_enterprise_support/system/services.txt

  Contains the output of `chkconfig --list`.

  Only gathered on RedHat-based nodes.

- puppet_enterprise_support/system/umask.txt

  Contains the output of `umask`.

- puppet_enterprise_support/system/uname.txt

  Contains the output of `uname -a`.

- puppet_enterprise_support/system/uptime.txt

  Contains the output of `uptime`.
