function puppet_enterprise::calculate_puppetdb_command_processing_threads (
) >> Integer {
  $cpu = Integer($facts['processors']['count'])
  $percent_cpu_puppetdb = 0.25
  $minimum_cpu_puppetdb = 1
  $maximum_cpu_puppetdb = 3

  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $cmd_threads = pe_clamp($minimum_cpu_puppetdb,
                            Integer($cpu * $percent_cpu_puppetdb),
                            $maximum_cpu_puppetdb)
  } else {
    $cmd_threads = pe_max(Integer($cpu / 2), 1)
  }

}
