# frozen_string_literal: true
# Adapted from https://github.com/puppetlabs/puppetlabs-stdlib/blob/main/lib/puppet/functions/stdlib/to_json.rb

require 'json'
# @summary
#   Convert a data structure and output to JSON
Puppet::Functions.create_function(:'puppet_enterprise::to_json') do
  # @param data
  #   Data structure which needs to be converted into JSON
  #
  # @example Output JSON to a file
  #   file { '/tmp/my.json':
  #     ensure  => file,
  #     content => puppet_enterprise::to_json($myhash),
  #   }
  #
  # @return [String] Converted data to JSON
  dispatch :to_json do
    param 'Any', :data
  end

  def to_json(data)
    data.to_json
  end
end
