module ConfigTranslate

  # Translates a config hash that uses dashes in keys to using underscores in keys
  def self.key_dashes_to_underscores(config)
    # Iterates through the config hash, substitutes dashes in keys with underscores, then
    # recursively calls the transform function to perform the same tranformation on the keys
    # of any inner hashes
    #
    # Maps over any arrays found with the same recursive call in case the values in those
    # arrays are hashes
    if config.kind_of?(Hash)
      config.transform_keys { |key| key.gsub('-','_') }.transform_values { |value| key_dashes_to_underscores(value) }
    elsif config.kind_of?(Array)
      config.map { |value| key_dashes_to_underscores(value) }
    else
      config
    end
  end
end
