class puppet_enterprise::console_services(
  $client_certname,
  $master_host,
  Array[String]  $puppetdb_host,
  Array[Integer] $puppetdb_port,
  $orchestrator_host                 = $master_host,
  $orchestrator_port                 = $puppet_enterprise::orchestrator_port,
  $orchestrator_url_prefix           = $puppet_enterprise::orchestrator_url_prefix,
  $inventory_host                    = $orchestrator_host,
  Integer $inventory_port            = $puppet_enterprise::orchestrator_port,
  String $inventory_url_prefix       = $puppet_enterprise::inventory_url_prefix,
  $proxy_idle_timeout                = 60,
  Integer $master_port               = $puppet_enterprise::puppet_master_port,
  $classifier_host                   = $puppet_enterprise::console_host,
  $classifier_port                   = $puppet_enterprise::params::console_services_api_ssl_listen_port,
  $classifier_url_prefix             = $puppet_enterprise::params::classifier_url_prefix,
  $rbac_host                         = $puppet_enterprise::console_host,
  $rbac_port                         = $puppet_enterprise::params::console_services_api_ssl_listen_port,
  $activity_host                     = $puppet_enterprise::console_host,
  $activity_port                     = $puppet_enterprise::params::console_services_api_ssl_listen_port,
  $activity_url_prefix               = $puppet_enterprise::params::activity_url_prefix,
  Integer $query_cache_ttl           = $puppet_enterprise::params::console_services_query_cache_ttl,
  $localcacert                       = $puppet_enterprise::params::localcacert,
  Hash $java_args                    = $puppet_enterprise::params::console_services_java_args,
  Boolean $disable_string_deduplication = $puppet_enterprise::disable_string_deduplication,
  Optional[Boolean] $enable_gc_logging = undef,
  $status_proxy_enabled              = false,
  $service_stop_retries              = 60,
  $start_timeout                     = 300,
  Integer $reload_timeout            = 300,
  String $pcp_broker_host            = $puppet_enterprise::pcp_broker_host,
  Integer $pcp_broker_port           = $puppet_enterprise::pcp_broker_port,
  Integer $pcp_timeout               = 5,
  $service_alert_timeout             = 5000,
  Boolean $display_local_time        = false,
  String $session_maximum_lifetime   = '',
  Optional[Integer] $session_timeout = undef,
  Puppet_enterprise::Replication_mode $replication_mode = 'none',
  Optional[Integer] $no_longer_reporting_cutoff = undef,
  String $agent_installer_host       = lookup('pe_repo::compile_master_pool_address', {default_value => $master_host}),
  Integer $agent_installer_port      = $master_port,
  Optional[Integer] $max_connections_per_route = undef,
  Optional[Integer] $max_connections_total     = undef,
  String $custom_queries_path = $puppet_enterprise::custom_queries_path,
  Optional[Integer] $connect_timeout  = undef,
  Optional[Integer] $socket_timeout   = undef,
  String $disclaimer_content_path     = $puppet_enterprise::disclaimer_content_path,
  Boolean $flight_recorder_enabled    = $puppet_enterprise::flight_recorder_enabled,
  String $flight_recorder_settings    = $puppet_enterprise::flight_recorder_settings,
  Integer $flight_recorder_stackdepth = $puppet_enterprise::flight_recorder_stackdepth,
  String $flight_recorder_maxage      = $puppet_enterprise::flight_recorder_maxage,
  String $flight_recorder_maxsize     = $puppet_enterprise::flight_recorder_maxsize,
  String $flight_recorder_repository  = '/var/log/puppetlabs/console-services/jfr',
  String $flight_recorder_filename    = '/var/log/puppetlabs/console-services/last_recording.jfr',
  Integer $session_timeout_polling_frequency_seconds = $puppet_enterprise::params::console_session_timeout_polling_frequency_seconds,
  Integer $session_timeout_warning_seconds           = $puppet_enterprise::params::console_session_timeout_warning_seconds,
) inherits puppet_enterprise::params {
  include puppet_enterprise::packages

  pe_validate_single_integer($service_stop_retries)
  pe_validate_single_integer($start_timeout)

  $container = 'console-services'

  $confdir = '/etc/puppetlabs/console-services'

  puppet_enterprise::trapperkeeper::console_services { $container:
    client_certname                           => $client_certname,
    proxy_idle_timeout                        => $proxy_idle_timeout,
    master_host                               => $master_host,
    master_port                               => $master_port,
    orchestrator_host                         => $orchestrator_host,
    orchestrator_port                         => $orchestrator_port,
    orchestrator_url_prefix                   => $orchestrator_url_prefix,
    inventory_host                            => $inventory_host,
    inventory_port                            => $inventory_port,
    inventory_url_prefix                      => $inventory_url_prefix,
    classifier_host                           => $classifier_host,
    classifier_port                           => $classifier_port,
    classifier_url_prefix                     => $classifier_url_prefix,
    puppetdb_host                             => $puppetdb_host,
    puppetdb_port                             => $puppetdb_port,
    rbac_host                                 => $rbac_host,
    rbac_port                                 => $rbac_port,
    activity_host                             => $activity_host,
    activity_port                             => $activity_port,
    activity_url_prefix                       => $activity_url_prefix,
    localcacert                               => $localcacert,
    status_proxy_enabled                      => $status_proxy_enabled,
    pcp_timeout                               => $pcp_timeout,
    service_alert_timeout                     => $service_alert_timeout,
    display_local_time                        => $display_local_time,
    session_timeout                           => $session_timeout,
    session_maximum_lifetime                  => $session_maximum_lifetime,
    replication_mode                          => $replication_mode,
    query_cache_ttl                           => $query_cache_ttl,
    no_longer_reporting_cutoff                => $no_longer_reporting_cutoff,
    agent_installer_host                      => $agent_installer_host,
    agent_installer_port                      => $agent_installer_port,
    max_connections_per_route                 => $max_connections_per_route,
    max_connections_total                     => $max_connections_total,
    connect_timeout                           => $connect_timeout,
    socket_timeout                            => $socket_timeout,

    session_timeout_polling_frequency_seconds => $session_timeout_polling_frequency_seconds,
    session_timeout_warning_seconds           => $session_timeout_warning_seconds,

    require                                   => Package['pe-console-services'],
    notify                                    => Service['pe-console-services'],
    custom_queries_path                       => $custom_queries_path,
    disclaimer_content_path                   => $disclaimer_content_path
  }

  if $flight_recorder_enabled {
    $_jfr_java_args = puppet_enterprise::jfr_java_args(
      $flight_recorder_repository,
      $flight_recorder_filename,
      $flight_recorder_settings,
      $flight_recorder_stackdepth,
      $flight_recorder_maxage,
      $flight_recorder_maxsize
    )
  } else {
    $_jfr_java_args = {}
  }

  $_java_args = pe_merge($java_args, $_jfr_java_args)
  puppet_enterprise::trapperkeeper::java_args { $container :
    java_args                    => $_java_args,
    disable_string_deduplication => $disable_string_deduplication,
    enable_gc_logging            => $enable_gc_logging,
  }

  puppet_enterprise::trapperkeeper::init_defaults { $container :
    service_stop_retries => $service_stop_retries,
    start_timeout        => $start_timeout,
    reload_timeout       => $reload_timeout,
  }

  puppet_enterprise::trapperkeeper::pe_service { $container : }
}
