# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Tasks

* [`command`](#command): Run adhoc command.
* [`playbook`](#playbook): Run a YAML based automation playbook.

## Tasks

### <a name="command"></a>`command`

Run adhoc command.

**Supports noop?** false

#### Parameters

##### `command_executor_path`

Data type: `Optional[String[1]]`

The absolute path to the command executer. 
Required if command executor not available within PATH.

##### `additional_arguments`

Data type: `Optional[String[1]]`

Additional flags to pass to the command execution command.

##### `host_pattern`

Data type: `Optional[String[1]]`

The host pattern in the inventory file.

##### `inventory`

Data type: `Optional[String[1]]`

The absolute path to the inventory file. 
Or relative to project if project defined.

##### `module_name`

Data type: `Optional[String[1]]`

The name of the command module to run.

##### `module_args`

Data type: `Optional[String[1]]`

Any arguments that we want to pass to the command module.

##### `project`

Data type: `Optional[String[1]]`

The absolute path to the project.  
Allows for relative paths to be used for inventory.

##### `stdout_callback`

Data type: `Optional[String[1]]`

The callback formatter to be used. 
Allows for any available command output to be specified.

##### `user`

Data type: `Optional[String[1]]`

User account to switch to before running command. 
Useful when running via PE and command execution configured for non root user. 
*Requires passwordless sudo configured for root account.

### <a name="playbook"></a>`playbook`

Run a YAML based automation playbook.

**Supports noop?** false

#### Parameters

##### `playbook_executor_path`

Data type: `Optional[String[1]]`

The absolute path to the playbook executer. 
Required if playbook executor not available within PATH.

##### `additional_arguments`

Data type: `Optional[String[1]]`

Additional flags to pass to the playbook execution command.

##### `inventory`

Data type: `Optional[String[1]]`

The absolute path to the inventory file. 
Or relative to project if project defined.

##### `playbook`

Data type: `String[1]`

The absolute path to the YAML based playbook to run.  
Or relative to project if project defined.

##### `project`

Data type: `Optional[String[1]]`

The absolute path to the project.  
Allows for relative paths to be used for inventory and playbook.

##### `stdout_callback`

Data type: `Optional[String[1]]`

The callback formatter to be used. 
Allows for any available playbook output to be specified.

##### `user`

Data type: `Optional[String[1]]`

User account to switch to before running playbook. 
Useful when running via PE and playbook execution configured for non root user. 
*Requires passwordless sudo from root account.

