# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`pe_databases`](#pe_databases): Tuning, maintenance for PE PostgreSQL.
* [`pe_databases::pg_repack`](#pe_databases--pg_repack): Provides systemd timers to pg_repack tables in a given database

### Defined types

* [`pe_databases::collect`](#pe_databases--collect): Create systemd units for repacking a given database type

### Tasks

* [`reset_pgrepack_schema`](#reset_pgrepack_schema): This task will remove and recreate the pg_repack extension

## Classes

### <a name="pe_databases"></a>`pe_databases`

Tuning, maintenance for PE PostgreSQL.

#### Parameters

The following parameters are available in the `pe_databases` class:

* [`manage_database_maintenance`](#-pe_databases--manage_database_maintenance)
* [`disable_maintenance`](#-pe_databases--disable_maintenance)
* [`install_dir`](#-pe_databases--install_dir)
* [`scripts_dir`](#-pe_databases--scripts_dir)
* [`facts_tables_repack_timer`](#-pe_databases--facts_tables_repack_timer)
* [`catalogs_tables_repack_timer`](#-pe_databases--catalogs_tables_repack_timer)
* [`other_tables_repack_timer`](#-pe_databases--other_tables_repack_timer)
* [`activity_tables_repack_timer`](#-pe_databases--activity_tables_repack_timer)
* [`manage_postgresql_settings`](#-pe_databases--manage_postgresql_settings)
* [`manage_table_settings`](#-pe_databases--manage_table_settings)
* [`reports_tables_repack_timer`](#-pe_databases--reports_tables_repack_timer)
* [`resource_events_tables_repack_timer`](#-pe_databases--resource_events_tables_repack_timer)

##### <a name="-pe_databases--manage_database_maintenance"></a>`manage_database_maintenance`

Data type: `Boolean`

true or false (Default: true)
Manage the inclusion of the pg_repack class

Default value: `true`

##### <a name="-pe_databases--disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`

true or false (Default: false)
Disable or enable maintenance mode

Default value: `false`

##### <a name="-pe_databases--install_dir"></a>`install_dir`

Data type: `String[1]`

Directory to install module into (Default: "/opt/puppetlabs/pe_databases")

Default value: `'/opt/puppetlabs/pe_databases'`

##### <a name="-pe_databases--scripts_dir"></a>`scripts_dir`

Data type: `String[1]`

Directory to install scripts into (Default: "${install_dir}/scripts")

Default value: `"${install_dir}/scripts"`

##### <a name="-pe_databases--facts_tables_repack_timer"></a>`facts_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'facts' tables

##### <a name="-pe_databases--catalogs_tables_repack_timer"></a>`catalogs_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'catalog' tables

##### <a name="-pe_databases--other_tables_repack_timer"></a>`other_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'other' tables

##### <a name="-pe_databases--activity_tables_repack_timer"></a>`activity_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'activity' tables

##### <a name="-pe_databases--manage_postgresql_settings"></a>`manage_postgresql_settings`

Data type: `Optional[Boolean]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

##### <a name="-pe_databases--manage_table_settings"></a>`manage_table_settings`

Data type: `Optional[Boolean]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

##### <a name="-pe_databases--reports_tables_repack_timer"></a>`reports_tables_repack_timer`

Data type: `Optional[String]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

##### <a name="-pe_databases--resource_events_tables_repack_timer"></a>`resource_events_tables_repack_timer`

Data type: `Optional[String]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

### <a name="pe_databases--pg_repack"></a>`pe_databases::pg_repack`

Maintenance pg_repack

#### Parameters

The following parameters are available in the `pe_databases::pg_repack` class:

* [`fact_tables`](#-pe_databases--pg_repack--fact_tables)
* [`catalog_tables`](#-pe_databases--pg_repack--catalog_tables)
* [`other_tables`](#-pe_databases--pg_repack--other_tables)
* [`activity_tables`](#-pe_databases--pg_repack--activity_tables)
* [`disable_maintenance`](#-pe_databases--pg_repack--disable_maintenance)
* [`repack_log_level`](#-pe_databases--pg_repack--repack_log_level)
* [`enable_echo`](#-pe_databases--pg_repack--enable_echo)
* [`jobs`](#-pe_databases--pg_repack--jobs)
* [`facts_tables_repack_timer`](#-pe_databases--pg_repack--facts_tables_repack_timer)
* [`catalogs_tables_repack_timer`](#-pe_databases--pg_repack--catalogs_tables_repack_timer)
* [`other_tables_repack_timer`](#-pe_databases--pg_repack--other_tables_repack_timer)
* [`activity_tables_repack_timer`](#-pe_databases--pg_repack--activity_tables_repack_timer)
* [`reports_tables_repack_timer`](#-pe_databases--pg_repack--reports_tables_repack_timer)
* [`resource_events_tables_repack_timer`](#-pe_databases--pg_repack--resource_events_tables_repack_timer)

##### <a name="-pe_databases--pg_repack--fact_tables"></a>`fact_tables`

Data type: `Array`

Array of 'fact' tables to repack

##### <a name="-pe_databases--pg_repack--catalog_tables"></a>`catalog_tables`

Data type: `Array`

Array of 'catalog' tables to repack

##### <a name="-pe_databases--pg_repack--other_tables"></a>`other_tables`

Data type: `Array`

Array of 'other' tables to repack

##### <a name="-pe_databases--pg_repack--activity_tables"></a>`activity_tables`

Data type: `Array`

Array of 'activity' tables to repack

##### <a name="-pe_databases--pg_repack--disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`

true or false (Default: false)
Disable or enable maintenance mode

Default value: `false`

##### <a name="-pe_databases--pg_repack--repack_log_level"></a>`repack_log_level`

Data type: `Enum['INFO','NOTICE','WARNING','ERROR','LOG','FATAL','PANIC','DEBUG']`

Desired output level of logs

Default value: `'DEBUG'`

##### <a name="-pe_databases--pg_repack--enable_echo"></a>`enable_echo`

Data type: `Boolean`

true or false (Default: true)
Enabling echo output in logs

Default value: `true`

##### <a name="-pe_databases--pg_repack--jobs"></a>`jobs`

Data type: `Integer`

How many jobs to run in parallel

Default value: `$facts['processors']['count'] / 4`

##### <a name="-pe_databases--pg_repack--facts_tables_repack_timer"></a>`facts_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'facts' tables

Default value: `$pe_databases::facts_tables_repack_timer`

##### <a name="-pe_databases--pg_repack--catalogs_tables_repack_timer"></a>`catalogs_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'catalog' tables

Default value: `$pe_databases::catalogs_tables_repack_timer`

##### <a name="-pe_databases--pg_repack--other_tables_repack_timer"></a>`other_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'other' tables

Default value: `$pe_databases::other_tables_repack_timer`

##### <a name="-pe_databases--pg_repack--activity_tables_repack_timer"></a>`activity_tables_repack_timer`

Data type: `String[1]`

The Systemd timer for the pg_repack job affecting the 'activity' tables

Default value: `$pe_databases::activity_tables_repack_timer`

##### <a name="-pe_databases--pg_repack--reports_tables_repack_timer"></a>`reports_tables_repack_timer`

Data type: `Optional[String]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

##### <a name="-pe_databases--pg_repack--resource_events_tables_repack_timer"></a>`resource_events_tables_repack_timer`

Data type: `Optional[String]`

Deprecated Parameter will be removed in future releases

Default value: `undef`

## Defined types

### <a name="pe_databases--collect"></a>`pe_databases::collect`

Create systemd units for repacking a given database type

#### Parameters

The following parameters are available in the `pe_databases::collect` defined type:

* [`database_type`](#-pe_databases--collect--database_type)
* [`command`](#-pe_databases--collect--command)
* [`disable_maintenance`](#-pe_databases--collect--disable_maintenance)
* [`on_cal`](#-pe_databases--collect--on_cal)
* [`tables`](#-pe_databases--collect--tables)

##### <a name="-pe_databases--collect--database_type"></a>`database_type`

Data type: `String`

The database to repack, uses titles from pg_repack.pp

Default value: `$title`

##### <a name="-pe_databases--collect--command"></a>`command`

Data type: `String`

defined in pg_repack.pp

Default value: `undef`

##### <a name="-pe_databases--collect--disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`

to disable maintenance mode (Default: false)

Default value: `false`

##### <a name="-pe_databases--collect--on_cal"></a>`on_cal`

Data type: `String`

values can be found in pg_repack.pp

Default value: `undef`

##### <a name="-pe_databases--collect--tables"></a>`tables`

Data type: `Array`

Array of tables to repack

Default value: `undef`

## Tasks

### <a name="reset_pgrepack_schema"></a>`reset_pgrepack_schema`

This task will remove and recreate the pg_repack extension

**Supports noop?** false

