# puppet infrastructure reinitialize replica

## MAN PAGE

```
USAGE: puppet infrastructure reinitialize [-y | --yes] [--db DATABASE] <role>

DESCRIPTION:
Clear and re-synchronize replicated databases on the replica.

IMPORTANT: This resynchronizes all databases except for the pe-puppetdb database
which is replicated independently with PuppetDB.

REQUIREMENTS:
  - A provisioned replica to enable.

OPTIONS:
  --db <DATABASE>                   Reinitialize only this database
  --yes, -y                         Answer yes to all confirmations.
  --render-as <FORMAT>              The rendering format to use.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## Use cases

This command has a high probability of solving problems that result from
incorrect database state on the replica.
In most cases, these problems will surface immediately after the replica is
provisioned, hopefully before the replica is enabled.

Typically, database state problems will cause something like the following in
`/var/log/puppetlabs/postgresql/postgresql-*.log` on the replica:

  * "ERROR: subscriber ... failed during nonrecoverable step..."
  * "ERROR: could not create unique index..."

These errors can also cause the following error to show up in "/var/log/puppetlabs/console-services.log":

  * "org.postgresql.util.PSQLException: ERROR: function show_subscription_status() does not exist"

## Warnings

* The kinds of errors that reinitialization addresses are almost always going to
  be so severe that the replica is totally unable to serve requests.
* Reinitialization probably *will not* help in the case of slow queries or
  intermittent failures.
* Reinitialization requires a fully-functional primary master. Do not attempt it
  when the replica cannot reach the primary master.
* Reinitialization is a highly-destructive operation that will drop all of the
  PE databases on the replica. It will not affect data elsewhere on the replica
  or anywhere else.

## Steps to run

There are no pre-requisites.
On the replica, run "puppet infra reinitialize replica".
The tool will provide prompts for subsequent steps.

## Status during reinitialization

The intended use for this command is to fix a completely non-working replica, so
the command itself will not further degrade availability. That said, if you
reinitialize replication while the replica is able to serve requests, it will
lose that ability until the initial replication is complete.

The situation where you'd run this command is after you've run "puppet infra
provision replica <certname>" and noticed that replication has not succeeded,
hopefully before running "puppet infra enable replica <certname>".
