# puppet infrastructure run

The `puppet-infra run` command is an action of the Puppet infrastructure face
that provides an abstraction around running Bolt plans from the
`enterprise_tasks` repository via either Orchestrator or Bolt, depending on the
requirements of the plan.

The available plans (and their user facing versus `enterprise_tasks` plan name)
is kept in the [Puppet::Face infrastructure
run](modules/pe_manager/lib/puppet/face/infrastructure/run.rb)
`command_mappings` hash. The `command_engine` hash determines wether a given
plan will be executed using orchestrator or bolt. The plans requiring bolt
involve some restart of PE orchestration services that would interrupt the plan
in execution, causing it to fail (primary cert regeneration, for example).

The abstractions for interacting with Bolt and Orchestrator are rooted in
PuppetX::Util::Bolt and PuppetX:Puppetlabs::Meep::Infra::PlanExecutor (both of
these libraries are in `pe_manager/lib`).

The PlanExecutor is likewise used by the Upgrade and Provision actions.

The Bolt/Ruby runtime used by the Run action is shipped in the pe-installer
package. It is completely separate from the pe-bolt-server runtime.

The `enterprise_tasks` plans that run executes are shipped in the pe-modules
package and are available on the basemodulepath under
/opt/puppetlabs/puppet/modules.

A particular plan must be allow-listed in `enterprise_tasks` before it will be
packaged in pe-modules. See that repository for details.
