module PuppetX
module Puppetlabs
module Meep

  # A handful of simple utilities for caching expensive lookups in a local
  # instance variable hash.
  #
  # Usage:
  #
  #   def something_costly
  #     cached(:something_costly) do
  #       expensive_lookup
  #     end
  #   end
  module Caching
    # This is a test convenience
    # @api private
    def clear_cache
      @configure_cache = {}
    end

    # @api private
    def cache
      @configure_cache ||= {}
    end

    # @api private
    def cached(key)
      if !cache.include?(key)
        cache[key] = yield
      end
      cache[key]
    end
  end
end
end
end
