require 'puppet_x/util/password'

module PuppetX
module Puppetlabs
module Meep
module Configure

  # Subroutines handling the console admin password reset url at the end of a fresh install.
  module Password

    # Write a valid url for resetting the console admin password to
    # /opt/puppetlabs/server/share/installer/reset-url. The shim will reference
    # this file if present.
    def notify_reset_url
      begin
        output = PuppetX::Util::PasswordUtils.console_reset_admin_url
        write_to_reset_url_file(output)
      rescue StandardError => e
        Puppet.err(_("A problem was encountered while attempting to generate a Reset Token - %{error_message}") % {error_message: e.message})
      end
    end

    def write_to_reset_url_file(url)
      reset_url_file = '/opt/puppetlabs/server/share/installer/reset-url'
      reset_dir = File.dirname(reset_url_file)
      FileUtils.mkdir_p(reset_dir)
      File.open(reset_url_file, 'w', 0600) do |file|
        file.write(url)
      end
    end

    # Revoke the admin account. Admin access is unavailable until the reset url
    # is followed.
    def revoke_admin_access
      begin
        PuppetX::Util::PasswordUtils.revoke_admin_access
      rescue StandardError => e
        Puppet.err(_("A problem was encountered when ensuring the admin account is inaccessible until a password is set - %{error_message}") % {error_message: e.message})
      end
    end

    # Conditionally revoke admin account if password is default.
    def check_for_default_password_and_revoke
      begin
        PuppetX::Util::PasswordUtils.check_for_default_password_and_revoke
      rescue StandardError => e
        Puppet.err(_("A problem was encountered when ensuring the admin account is inaccessible until a password is set - %{error_message}") % {error_message: e.message})
      end
    end
  end
end
end
end
end
