require 'puppet_x/util/stringformatter'

module PuppetX
module Puppetlabs
module Meep
module Enable
  module Flags

    def self.add_flags(action)

      action.option('-y', '--yes') do
        summary _("Answer yes to all confirmations.")
        description PuppetX::Util::String::Formatter.indent(
          _("Answer yes to all confirmations."),
          PuppetX::Util::String::Formatter.indent_level(1))
      end

      action.option('--topology <topology>') do
        summary _("The topology of your PE installation")
        description PuppetX::Util::String::Formatter.indent(
            _("The topology of your pe installation:"
          ), PuppetX::Util::String::Formatter.indent_level(1)) + "\n" +
          PuppetX::Util::String::Formatter.join_and_indent([
            _("mono - All PE services run on the primary and all agents connect to that primary."),
            _("mono-with-compile - All PE services run on the primary but agents connect to compilers.")
          ], PuppetX::Util::String::Formatter.indent_level(2))
      end

      action.option('--skip-agent-config') do
        summary _("Do not change agent settings")
        default_to {nil}
        description PuppetX::Util::String::Formatter.indent(
          _("Do not change agent settings when enabling replica. Agent failover settings must be configured by the user."))
      end

      action.option('--pcp-brokers <uris>') do
        summary _("Hostnames and ports of your PCP Brokers")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--infra-pcp-brokers <uris>') do
        summary _("Hostnames and ports of your PCP Brokers for PE infrastructure")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--puppetdb-termini <uris>') do
        summary _("Hostnames and ports of your PuppetDBs")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--classifier-termini <uris>') do
        summary _("Hostnames and ports of your Node Classifiers")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--agent-server-urls <uris>') do
        summary _("Hostnames and ports of your Primary Servers to run your Puppet Agents against")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--infra-agent-server-urls <uris>') do
        summary _("Hostnames and ports your Primary Servers to run your Puppet Infrastructure Agents against")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--primary-uris <uris>') do
        summary _("Hostnames and ports of your Primary Servers to connect PXP agents to")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end

      action.option('--infra-primary-uris <uris>') do
        summary _("Hostnames and ports your Primary Servers to connect your Puppet Infrastructure PXP agents to")
        description <<-EOT
          hostname:port,hostname:port
        EOT
      end
    end
  end
end
end
end
end