require 'puppet_x/puppetlabs/meep/caching'
require 'puppet_x/puppetlabs/meep/infra/lookup'

module PuppetX
module Puppetlabs
module Meep
module Infra

  # These methods answer simple questions about the layout of the PE installation.
  # Which node is the primary and whether the database is a separate node.
  module Layout
    include PuppetX::Puppetlabs::Meep::Caching
    include PuppetX::Puppetlabs::Meep::Infra::Lookup

    def installed?
      !pe_server_version.nil?
    end

    def master?
      cached(:pe_puppetserver_package) do
        package_present?('pe-puppetserver')
      end
    end

    # True if this node has the Postgresql server package installed, and is
    # therefore a database node.
    def postgres? 
      cached(:pe_postgres_package) do
        package_present?('pe-postgresql14-server') || package_present?('pe-postgresql11-server')
      end
    end

    # If the database host is not one of the three primary hosts, this is an
    # indication that it may be an externally managed database.
    #
    # @return [Boolean] true if this installation is configured with a
    #   database that is not one of the primary, puppetdb, or console nodes.
    def separate_database_node?
      cached(:separate_database_node) do
        database_host = database_host_parameter

        if database_host.nil?
          false
        else
          master_host = puppet_lookup('puppet_enterprise::puppet_master_host')
          console_host = puppet_lookup('puppet_enterprise::console_host')
          puppetdb_host = puppet_lookup('puppet_enterprise::puppetdb_host')
          primary_infrastructure = [master_host, console_host, puppetdb_host].compact

          !primary_infrastructure.include?(database_host)
        end
      end
    end
    
    def database_host_parameter
      cached(:database_host) do
        puppet_lookup('puppet_enterprise::database_host')
      end
    end

    def console_node?
      puppet_master_host = puppet_lookup("puppet_enterprise::puppet_master_host")
      console_host = puppet_lookup('puppet_enterprise::console_host')
      certname = Puppet[:certname]

      console_host.nil? ?
        puppet_master_host == certname :
        console_host == certname
    end
  end
end
end
end
end
