require 'fileutils'

module PuppetX
  module Util
    class CA

      def self.advance_ca_serial(ca_serial_file, amount_to_advance)
        File.open(ca_serial_file, 'r+') do |file|
          # this will convert the hex in the file to a decimal
          current_serial = file.gets.hex
          advanced_serial = current_serial + amount_to_advance
          file.rewind
          file.truncate(0)
          # The serial is padded up to 4 digits to be consistent with puppet itself
          # see https://github.com/puppetlabs/puppet/blob/master/lib/puppet/ssl/certificate_authority.rb#L227 for more details
          file.printf('%04X', advanced_serial)
        end
      end

    end
  end
end
