function puppet_enterprise::calculate_puppetdb_read_maximum_pool_size (
  Integer $command_processing_threads,
) >> Integer {
  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $jruby_instances = lookup('puppet_enterprise::master::puppetserver::jruby_max_active_instances',
      { default_value => puppet_enterprise::calculate_puppetserver_jruby_max_active_instances() })

    $puppetdb_read_maximum_pool_size = pe_max(Integer($jruby_instances), 2)
  } else {
    $puppetdb_read_maximum_pool_size = pe_max(25, ($command_processing_threads * 2))
  }
}
