# BE CAREFUL WITH THIS
# If you add this to a class that another resource subscribes to
# (e.g. puppet_enterprise::puppetdb::database_ini is subscribed to by
# the pe-puppetdb service resource), then the notify will cause a
# refresh event to get sent on every puppet run. You will probably want to
# contain the use of this define inside its own class to prevent these
# refresh events.
define puppet_enterprise::deprecated_parameter(
  Optional[String] $replacement = undef,
  Optional[Boolean] $suppress_on_install = false,
) {
  $value = pe_getvar($title)
  # storeconfigs is used as a proxy to determine when we are in the middle
  # of install/upgrade, rather than a regular puppet run. It will be false
  # during install/upgrade, and gets set to true when PuppetDB is ready.
  $installing = !$settings::storeconfigs
  if $replacement != undef {
    $message = "The ${title} parameter is deprecated and has been replaced by ${replacement}, which provides the same functionality. The deprecated parameter will be removed in a future release; however, it has been set to '${value}'. Please change your Classifier classification, hiera data, or /etc/puppetlabs/enterprise/conf.d/pe.conf, as appropriate, to use the new parameter."
  } else {
    $message = "The ${title} parameter is deprecated and will be removed in a future release; however, it has been set to '${value}'. Please remove it from your Classifier classification, hiera data or /etc/puppetlabs/enterprise/conf.d/pe.conf, as appropriate."
  }
  if $value != undef and !($suppress_on_install and $installing) {
    notify { "${title} is deprecated":
      message   => $message,
      loglevel => 'warning',
    }
  }
}
