define puppet_enterprise::pg::grant_connect(
  String $database,
  String $schema,
  String $user,
) {
  puppet_enterprise::psql {"${title}/sql":
    db      => $database,
    command => "GRANT CONNECT ON DATABASE \"${database}\"
                TO \"${user}\"",
    unless => "SELECT * from pg_database
                 WHERE datacl @> makeaclitem(
                                   (SELECT oid FROM pg_roles WHERE rolname = '${user}'),
                                   (SELECT oid FROM pg_roles WHERE rolname = 'pe-postgres'),
                                   'CONNECT',
                                   false)"
  }
}
