class puppet_enterprise::trapperkeeper::infra_assistant (
  String $puppetdb_url,
  String $container = 'infra-assistant',
  String $service_name = 'pe-infra-assistant',
  String $user      = "pe-${container}",
  String $group     = "pe-${container}",
  Boolean $enable_mcp_server = false,
  String $database_host = $puppet_enterprise::infra_assistant_database_host,
  Puppet_enterprise::Port $database_port = $puppet_enterprise::database_port,
  String $orchestrator_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::orchestrator_port}${puppet_enterprise::orchestrator_url_prefix}",
  String $classifier_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::params::console_services_api_ssl_listen_port}${puppet_enterprise::classifier_url_prefix}",
  String $ai_service_orchestrator_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::orchestrator_port}${puppet_enterprise::orchestrator_url_prefix}",
  String $ai_service_classifier_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::params::console_services_api_ssl_listen_port}${puppet_enterprise::classifier_url_prefix}",
  String $ai_service_rbac_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::params::console_services_api_ssl_listen_port}${puppet_enterprise::params::rbac_url_prefix}",
  String $ai_service_puppetdb_url = "https://${puppet_enterprise::puppetdb_hosts_array[0]}:${puppet_enterprise::puppetdb_ports_array[0]}",
  String $ai_service_puppetserver_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::puppet_master_port}",
  String $ai_service_codemanager_url = "https://${puppet_enterprise::puppet_master_host}:8170",
  String $ai_service_patching_url = $puppet_enterprise::patching_service_url,
  String $ai_service_vulnerability_url = $puppet_enterprise::vulnerability_service_url,
  String $ai_service_license_url = $puppet_enterprise::license_url,
  String $ai_service_forge_url = 'https://forgeapi.puppet.com',
  String $database_name = $puppet_enterprise::infra_assistant_database_name,
  String $database_user = $puppet_enterprise::infra_assistant_regular_db_user,
  String $database_migration_user = $puppet_enterprise::infra_assistant_migration_db_user,
  String $database_properties     = $puppet_enterprise::database_properties,
  Optional[String] $database_password = undef,
  String $rbac_url = $puppet_enterprise::rbac_url,
  String $activity_url = "https://${puppet_enterprise::console_host}:${puppet_enterprise::api_port}${puppet_enterprise::activity_url_prefix}",
  String $license_url = $puppet_enterprise::license_url,
) {
  $confdir = "/etc/puppetlabs/${container}/conf.d"
  $service_conf = "${confdir}/pe-infra-assistant.conf"

  ### Trapperkeeper bootstrap cfg entries ###
  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}: pe-infra-assistant":
    namespace => 'puppetlabs.pe-infra-assistant.service',
    service   => 'pe-infra-assistant',
    container => $container,
  }

  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}: remote-rbac-consumer-service":
    namespace => 'puppetlabs.rbac-client.services.rbac',
    service   => 'remote-rbac-consumer-service',
    container => $container,
  }

  ### Hocon configuration ###
  $common_hocon_settings = {
    ensure  => present,
    notify  => Service["pe-${container}"],
  }

  file { $service_conf:
    ensure => file,
    owner  => $user,
    group  => $group,
    mode   => '0640',
  }

  file { "${confdir}/secrets":
    ensure => directory,
    owner  => $user,
    group  => $group,
    mode   => '0640',
  }

  pe_hocon_setting { "${container}.puppetdb-url":
    path    => $service_conf,
    setting => 'pe-infra-assistant.puppetdb-url',
    value   => $puppetdb_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.orchestrator-url":
    path    => $service_conf,
    setting => 'pe-infra-assistant.orchestrator-url',
    value   => $orchestrator_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.classifier-url":
    path    => $service_conf,
    setting => 'pe-infra-assistant.classifier-url',
    value   => $classifier_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.rbac-consumer.api-url":
    path    => $service_conf,
    setting => 'rbac-consumer.api-url',
    value   => $rbac_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.activity-consumer.api-url":
    path    => $service_conf,
    setting => 'activity-consumer.api-url',
    value   => $activity_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.keypath":
    path    => $service_conf,
    setting => 'pe-infra-assistant.keypath',
    value   => "${confdir}/secrets",
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.license-url":
    path    => $service_conf,
    setting => 'pe-infra-assistant.license-url',
    value   => $license_url,
    *       => $common_hocon_settings,
  }

  ### Service urls
  pe_hocon_setting { "${container}.service-urls.puppetdb":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.puppetdb',
    value   => $ai_service_puppetdb_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.orchestrator":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.orchestrator',
    value   => $ai_service_orchestrator_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.classifier":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.classifier',
    value   => $ai_service_classifier_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.rbac":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.rbac',
    value   => $ai_service_rbac_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.codemanager":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.codemanager',
    value   => $ai_service_codemanager_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.puppetserver":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.puppetserver',
    value   => $ai_service_puppetserver_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.patching":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.patching',
    value   => $ai_service_patching_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.vrs":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.vrs',
    value   => $ai_service_vulnerability_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.license":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.license',
    value   => $ai_service_license_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.service-urls.forge":
    path    => $service_conf,
    setting => 'pe-infra-assistant.service-urls.forge',
    value   => $ai_service_forge_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.mcp.enabled":
    path    => $service_conf,
    setting => 'pe-infra-assistant.mcp.enabled',
    value   => $enable_mcp_server,
    *       => $common_hocon_settings,
  }

  ### Database configuration ###
  puppet_enterprise::trapperkeeper::database_settings { $service_name:
    container           => $container,
    database_host       => $database_host,
    database_name       => $database_name,
    database_password   => $database_password,
    database_port       => Integer($database_port),
    database_properties => $database_properties,
    database_user       => $database_user,
    migration_user      => $database_migration_user,
    migration_password  => $database_password,
    group               => $group,
    user                => $user,
    notify              => Service["pe-${container}"],
    require             => Package["pe-${container}"],
  }
}
