class puppet_enterprise::trapperkeeper::patching(
  String $puppetdb_url,
  String $container = 'patching-service',
  String $service_name = 'pe-patching-service',
  String $user      = "pe-${container}",
  String $group     = "pe-${container}",
  String $database_host = $puppet_enterprise::patching_database_host,
  Puppet_enterprise::Port $database_port = $puppet_enterprise::database_port,
  $orchestrator_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::orchestrator_port}${puppet_enterprise::orchestrator_url_prefix}",
  $classifier_url = "https://${puppet_enterprise::puppet_master_host}:${puppet_enterprise::params::console_services_api_ssl_listen_port}${puppet_enterprise::classifier_url_prefix}",
  String $database_name = $puppet_enterprise::patching_database_name,
  String $database_user = $puppet_enterprise::patching_service_regular_db_user,
  String $database_migration_user = $puppet_enterprise::patching_service_migration_db_user,
  String $database_properties     = $puppet_enterprise::database_properties,
  Optional[String] $database_password = undef,
  String $rbac_url = $puppet_enterprise::rbac_url,
  String $activity_url = $puppet_enterprise::activity_url,
  Integer $operations_purge_run_interval_ms = 86400000,
  Integer $operations_purge_age_days = 60,
  Integer $node_group_enforcement_interval_seconds = 3600,
  Integer $package_updates_run_interval_ms = 900000,
  Integer $package_updates_age_minutes = 30,
  Integer $operation_request_timeout = 60,
  Integer $worker_thread_pool_termination_max = 30,
  Integer $max_wait_iterations = 1000,
  Integer $iteration_sleep_time_ms = 1000,
  Integer $connectivity_wait_iterations = $max_wait_iterations,
  Integer $connectivity_sleep_time_ms = $iteration_sleep_time_ms,
  Integer $job_running_wait_iterations = $max_wait_iterations,
  Integer $job_running_sleep_time_ms = $iteration_sleep_time_ms,
  Integer $bootstrapping_check_interval = 2,
  Integer $bootstrapping_check_iterations = 15,
  String $license_url = $puppet_enterprise::license_url,
  String $patching_callback_url = "https://${puppet_enterprise::patching_service_host}:${puppet_enterprise::patching_service_port}${$puppet_enterprise::patching_callback_url_prefix}",
) {
  $confdir = "/etc/puppetlabs/${container}/conf.d"
  $service_conf = "${confdir}/pe-patching-service.conf"

  ### Trapperkeeper bootstrap cfg entries ###
  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}:patching pe-patching-service":
    namespace => 'puppetlabs.pe-patching-service.service',
    service   => 'pe-patching-service',
    container => $container,
  }
  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}: vulnerability-remediation-service":
    namespace => 'puppetlabs.vulnerability-remediation.service',
    service   => 'vulnerability-remediation-service',
    container => $container,
  }
  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}: remote-rbac-consumer-service":
    namespace => 'puppetlabs.rbac-client.services.rbac',
    service   => 'remote-rbac-consumer-service',
    container => $container,
  }

  ### Hocon configuration ###
  $common_hocon_settings = {
    ensure  => present,
    notify  => Service["pe-${container}"],
  }

  file { $service_conf:
    ensure => file,
    owner  => $user,
    group  => $group,
    mode   => '0640',
  }

  file { "${confdir}/secrets":
    ensure => directory,
    owner  => $user,
    group  => $group,
    mode   => '0640',
  }

  pe_hocon_setting { "${container}.puppetdb-url":
    path    => $service_conf,
    setting => 'pe-patching-service.puppetdb-url',
    value   => $puppetdb_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.orchestrator-url":
    path    => $service_conf,
    setting => 'pe-patching-service.orchestrator-url',
    value   => $orchestrator_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.classifier-url":
    path    => $service_conf,
    setting => 'pe-patching-service.classifier-url',
    value   => $classifier_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.license-url":
    path    => $service_conf,
    setting => 'pe-patching-service.license-url',
    value   => $license_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.rbac-consumer.api-url":
    path    => $service_conf,
    setting => 'rbac-consumer.api-url',
    value   => $rbac_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting {"${container}.activity-consumer.api-url":
    path    => $service_conf,
    setting => 'activity-consumer.api-url',
    value   => $activity_url,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.operations-purge-run-interval-ms":
    path    => $service_conf,
    setting => 'pe-patching-service.operations-purge-run-interval-ms',
    value   => $operations_purge_run_interval_ms,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.operations-purge-age-days":
    path    => $service_conf,
    setting => 'pe-patching-service.operations-purge-age-days',
    value   => $operations_purge_age_days,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.node-group-enforcement-interval-seconds":
    path    => $service_conf,
    setting => 'pe-patching-service.node-group-enforcement-interval-seconds',
    value   => $node_group_enforcement_interval_seconds,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.package-updates-run-interval-ms":
    path    => $service_conf,
    setting => 'pe-patching-service.package-updates-run-interval-ms',
    value   => $package_updates_run_interval_ms,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.package-updates-age-minutes":
    path    => $service_conf,
    setting => 'pe-patching-service.package-updates-age-minutes',
    value   => $package_updates_age_minutes,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.operation-request-timeout":
    path    => $service_conf,
    setting => 'pe-patching-service.operation-request-timeout',
    value   => $operation_request_timeout,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.worker-thread-pool-termination-max":
    path    => $service_conf,
    setting => 'pe-patching-service.worker-thread-pool-termination-max',
    value   => $worker_thread_pool_termination_max,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.max-wait-iterations":
    path    => $service_conf,
    setting => 'pe-patching-service.max-wait-iterations',
    value   => $max_wait_iterations,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.iteration-sleep-time-ms":
    path    => $service_conf,
    setting => 'pe-patching-service.iteration-sleep-time-ms',
    value   => $iteration_sleep_time_ms,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.connectivity-wait-iterations":
    path    => $service_conf,
    setting => 'pe-patching-service.connectivity-wait-iterations',
    value   => $connectivity_wait_iterations,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.connectivity-sleep-time-ms":
    path    => $service_conf,
    setting => 'pe-patching-service.connectivity-sleep-time-ms',
    value   => $connectivity_sleep_time_ms,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.job-running-wait-iterations":
    path    => $service_conf,
    setting => 'pe-patching-service.job-running-wait-iterations',
    value   => $job_running_wait_iterations,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.job-running-sleep-time-ms":
    path    => $service_conf,
    setting => 'pe-patching-service.job-running-sleep-time-ms',
    value   => $job_running_sleep_time_ms,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.bootstrapping-check-interval":
    path    => $service_conf,
    setting => 'pe-patching-service.bootstrapping-check-interval',
    value   => $bootstrapping_check_interval,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.bootstrapping-check-iterations":
    path    => $service_conf,
    setting => 'pe-patching-service.bootstrapping-check-iterations',
    value   => $bootstrapping_check_iterations,
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.keypath":
    path    => $service_conf,
    setting => 'pe-patching-service.keypath',
    value   => "${confdir}/secrets",
    *       => $common_hocon_settings,
  }

  pe_hocon_setting { "${container}.callback-url":
    path    => $service_conf,
    setting => 'pe-patching-service.callback-url',
    value   => $patching_callback_url,
    *       => $common_hocon_settings,
  }

  ### Database configuration ###
  puppet_enterprise::trapperkeeper::database_settings { $service_name:
    container           => $container,
    database_host       => $database_host,
    database_name       => $database_name,
    database_password   => $database_password,
    database_port       => Integer($database_port),
    database_properties => $database_properties,
    database_user       => $database_user,
    migration_user      => $database_migration_user,
    migration_password  => $database_password,
    group               => $group,
    user                => $user,
    notify              => Service["pe-${container}"],
    require             => Package["pe-${container}"],
  }
}
