# pe_concat

#### Table of Contents

1. [Overview](#overview)
2. [Module Description - What the module does and why it is useful](#module-description)
    * [Beginning with pe_concat](#beginning-with-pe_concat)
3. [Usage - Configuration options and additional functionality](#usage)
4. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
    * [Removed functionality](#removed-functionality)
5. [Development - Guide for contributing to the module](#development)

<a id="overview"></a>
## Overview

The pe_concat module lets you construct files from multiple ordered fragments of text.

<a id="module-description"></a>
## Module Description

The pe_concat module lets you gather `pe_concat::fragment` resources from your other modules and order them into a coherent file through a single `pe_concat` resource.

<a id="beginning-with-pe_concat"></a>
### Beginning with pe_concat

To start using pe_concat you need to create:

* A pe_concat{} resource for the final file.
* One or more pe_concat::fragment{}s.

A minimal example might be:

~~~
pe_concat { '/tmp/file':
  ensure => present,
}

pe_concat::fragment { 'tmpfile':
  target  => '/tmp/file',
  content => 'test contents',
  order   => '01'
}
~~~

<a id="usage"></a>
## Usage

### Maintain a list of the major modules on a node

To maintain an motd file that lists the modules on one of your nodes, first create a class to frame up the file:

~~~
class motd {
  $motd = '/etc/motd'

  pe_concat { $motd:
    owner => 'root',
    group => 'root',
    mode  => '0644'
  }

  pe_concat::fragment { 'motd_header':
    target  => $motd,
    content => "\nPuppet modules on this server:\n\n",
    order   => '01'
  }

  # let local users add to the motd by creating a file called
  # /etc/motd.local
  pe_concat::fragment { 'motd_local':
    target => $motd,
    source => '/etc/motd.local',
    order  => '15'
  }
}

# let other modules register themselves in the motd
define motd::register (
  $content = "",
  $order   = '10',
) {
  if $content == "" {
    $body = $name
  } else {
    $body = $content
  }

  pe_concat::fragment { "motd_fragment_$name":
    target  => '/etc/motd',
    order   => $order,
    content => "    -- $body\n"
  }
}
~~~

Then, in the declarations for each module on the node, add `motd::register{ 'Apache': }` to register the module in the motd.

~~~
class apache {
  include apache::install, apache::config, apache::service

  motd::register { 'Apache': }
}
~~~

These two steps populate the /etc/motd file with a list of the installed and registered modules, which stays updated even if you just remove the registered modules' `include` lines. System administrators can append text to the list by writing to /etc/motd.local.

When you're finished, the motd file will look something like this:

~~~
  Puppet modules on this server:

    -- Apache
    -- MySQL

  <contents of /etc/motd.local>
~~~

<a id="reference"></a>
## Reference

See [REFERENCE.md](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_concat/REFERENCE.md)

<a id="removed-functionality"></a>
### Removed functionality

The following functionality existed in previous versions of the pe_concat module, but was removed in version 2.0.0:

Parameters removed from `pe_concat::fragment`:
* `gnu`
* `backup`
* `group`
* `mode`
* `owner`

The `pe_concat::setup` class has also been removed.

Prior to pe_concat version 2.0.0, if you set the `warn` parameter to a string value of `true`, `false`, 'yes', 'no', 'on', or 'off', the module translated the string to the corresponding boolean value. In pe_concat version 2.0.0 and newer, the `warn_header` parameter treats those values the same as other strings and uses them as the content of your header message. To avoid that, pass the `true` and `false` values as booleans instead of strings.

## Development

To regenerate the reference documentation as follows:

```bash
puppet strings generate --format markdown --out REFERENCE.md
```

### Contributors

Richard Pijnenburg ([@Richardp82](http://twitter.com/richardp82))

Joshua Hoblitt ([@jhoblitt](http://twitter.com/jhoblitt))

[More contributors](https://github.com/puppetlabs/puppetlabs-concat/graphs/contributors).
