# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`puppet_metrics_collector`](#puppet_metrics_collector): This module manages the collection of Puppet and system Metrics
* [`puppet_metrics_collector::system`](#puppet_metrics_collector--system): This class manages collect postgres and system metrics

#### Private Classes

* `puppet_metrics_collector::service::ace`: Collects ace metrics
* `puppet_metrics_collector::service::bolt`: Collects bolt metrics
* `puppet_metrics_collector::service::console`: Collects console metrics
* `puppet_metrics_collector::service::orchestrator`: Collects orchestrator metrics
* `puppet_metrics_collector::service::puppetdb`: Collects puppetdb metrics
* `puppet_metrics_collector::service::puppetserver`: Collect puppetserver metrics
* `puppet_metrics_collector::system::postgres`: Collects postgres Metrics
* `puppet_metrics_collector::system::processes`: Collects System Processes Metrics
* `puppet_metrics_collector::system::sar`: Collects System CPU Metrics
* `puppet_metrics_collector::system::vmware`: Collects System vmware Metrics

### Defined types

* [`puppet_metrics_collector::collect`](#puppet_metrics_collector--collect): Creates systemd units for collecting a given metric
* [`puppet_metrics_collector::deprecated_parameter`](#puppet_metrics_collector--deprecated_parameter)
* [`puppet_metrics_collector::pe_metric`](#puppet_metrics_collector--pe_metric): A defined type to manage the configuration of tbe different metrics collection targets
* [`puppet_metrics_collector::sar_metric`](#puppet_metrics_collector--sar_metric): This class manages the collections of SAR metrics

### Functions

* [`puppet_metrics_collector::hosts_with_pe_profile`](#puppet_metrics_collector--hosts_with_pe_profile): Function: hosts_with_pe_profile  Queries PuppetDB for hosts with the specified Puppet Enterprise profile. Used by this module to query Puppet
* [`puppet_metrics_collector::to_yaml`](#puppet_metrics_collector--to_yaml): Description: Converts the content of the passed array or hash to YAML
* [`puppet_metrics_collector::version_based_excludes`](#puppet_metrics_collector--version_based_excludes): Function: version_based_excludes  Description: Generates a list of services to exlude based on the metrics type

## Classes

### <a name="puppet_metrics_collector"></a>`puppet_metrics_collector`

Optional Enum['splunk_hec']: The metrics server type to send data to. Default: undef

@ param metrics_server_hostname
Optional String: The hostname of the metrics server to send data to. Default: undef

@ param metrics_server_port
Optional Integer: The port number of the metrics server to send data to. Default: undef

Optional String: (Deprecated)The database name on the metrics server to send data to.
Default: undef

Optional String: Allows you to define the command that is executed to gather metrics. Default: undef

Optional String: Collection of ActiveMQ metrics has been removed, but the parameters are left to avoid breaking upgrades
Optional String: Collection of ActiveMQ metrics has been removed, but the parameters are left to avoid breaking upgrades
Optional Integer: Collection of ActiveMQ metrics has been removed, but the parameters are left to avoid breaking upgrades

#### Parameters

The following parameters are available in the `puppet_metrics_collector` class:

* [`puppetserver_metrics_ensure`](#-puppet_metrics_collector--puppetserver_metrics_ensure)
* [`output_dir`](#-puppet_metrics_collector--output_dir)
* [`collection_frequency`](#-puppet_metrics_collector--collection_frequency)
* [`retention_days`](#-puppet_metrics_collector--retention_days)
* [`puppetserver_hosts`](#-puppet_metrics_collector--puppetserver_hosts)
* [`puppetserver_port`](#-puppet_metrics_collector--puppetserver_port)
* [`puppetdb_metrics_ensure`](#-puppet_metrics_collector--puppetdb_metrics_ensure)
* [`puppetdb_hosts`](#-puppet_metrics_collector--puppetdb_hosts)
* [`puppetdb_port`](#-puppet_metrics_collector--puppetdb_port)
* [`orchestrator_metrics_ensure`](#-puppet_metrics_collector--orchestrator_metrics_ensure)
* [`orchestrator_hosts`](#-puppet_metrics_collector--orchestrator_hosts)
* [`orchestrator_port`](#-puppet_metrics_collector--orchestrator_port)
* [`console_metrics_ensure`](#-puppet_metrics_collector--console_metrics_ensure)
* [`console_hosts`](#-puppet_metrics_collector--console_hosts)
* [`console_port`](#-puppet_metrics_collector--console_port)
* [`ace_metrics_ensure`](#-puppet_metrics_collector--ace_metrics_ensure)
* [`ace_hosts`](#-puppet_metrics_collector--ace_hosts)
* [`ace_port`](#-puppet_metrics_collector--ace_port)
* [`bolt_metrics_ensure`](#-puppet_metrics_collector--bolt_metrics_ensure)
* [`bolt_hosts`](#-puppet_metrics_collector--bolt_hosts)
* [`bolt_port`](#-puppet_metrics_collector--bolt_port)
* [`metrics_server_type`](#-puppet_metrics_collector--metrics_server_type)
* [`metrics_server_db_name`](#-puppet_metrics_collector--metrics_server_db_name)
* [`override_metrics_command`](#-puppet_metrics_collector--override_metrics_command)
* [`activemq_metrics_ensure`](#-puppet_metrics_collector--activemq_metrics_ensure)
* [`activemq_hosts`](#-puppet_metrics_collector--activemq_hosts)
* [`activemq_port`](#-puppet_metrics_collector--activemq_port)
* [`puppetserver_excludes`](#-puppet_metrics_collector--puppetserver_excludes)
* [`puppetdb_excludes`](#-puppet_metrics_collector--puppetdb_excludes)
* [`orchestrator_excludes`](#-puppet_metrics_collector--orchestrator_excludes)
* [`console_excludes`](#-puppet_metrics_collector--console_excludes)
* [`ace_excludes`](#-puppet_metrics_collector--ace_excludes)
* [`bolt_excludes`](#-puppet_metrics_collector--bolt_excludes)
* [`activemq_excludes`](#-puppet_metrics_collector--activemq_excludes)
* [`metrics_server_hostname`](#-puppet_metrics_collector--metrics_server_hostname)
* [`metrics_server_port`](#-puppet_metrics_collector--metrics_server_port)

##### <a name="-puppet_metrics_collector--puppetserver_metrics_ensure"></a>`puppetserver_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of Puppetserver metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--output_dir"></a>`output_dir`

Data type: `String`

The directory to write the metrics to. Default: '/opt/puppetlabs/puppet-metrics-collector'

Default value: `'/opt/puppetlabs/puppet-metrics-collector'`

##### <a name="-puppet_metrics_collector--collection_frequency"></a>`collection_frequency`

Data type: `Integer`

The frequency to collect metrics in minutes. Default: '5'

Default value: `5`

##### <a name="-puppet_metrics_collector--retention_days"></a>`retention_days`

Data type: `Integer`

The number of days to retain metrics. Default: '90'

Default value: `90`

##### <a name="-puppet_metrics_collector--puppetserver_hosts"></a>`puppetserver_hosts`

Data type: `Array[String]`

The list of puppetserver hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the puppetserver profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('master')`

##### <a name="-puppet_metrics_collector--puppetserver_port"></a>`puppetserver_port`

Data type: `Integer`

Port to connect to puppetserver on. Default: '8140'

Default value: `8140`

##### <a name="-puppet_metrics_collector--puppetdb_metrics_ensure"></a>`puppetdb_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of PuppetDB metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--puppetdb_hosts"></a>`puppetdb_hosts`

Data type: `Array[String]`

The list of puppetdb hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the puppetdb profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('puppetdb')`

##### <a name="-puppet_metrics_collector--puppetdb_port"></a>`puppetdb_port`

Data type: `Integer`

Port to connect to puppetdb on. Default: '8081'

Default value: `8081`

##### <a name="-puppet_metrics_collector--orchestrator_metrics_ensure"></a>`orchestrator_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of Orchestrator metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--orchestrator_hosts"></a>`orchestrator_hosts`

Data type: `Array[String]`

The list of orchestrator hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the orchestrator profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('orchestrator')`

##### <a name="-puppet_metrics_collector--orchestrator_port"></a>`orchestrator_port`

Data type: `Integer`

Port to connect to orchestrator on. Default: '8143'

Default value: `8143`

##### <a name="-puppet_metrics_collector--console_metrics_ensure"></a>`console_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of PE Console metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--console_hosts"></a>`console_hosts`

Data type: `Array[String]`

The list of console hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the console profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('console')`

##### <a name="-puppet_metrics_collector--console_port"></a>`console_port`

Data type: `Integer`

Port to connect to console on. Default: '4433'

Default value: `4433`

##### <a name="-puppet_metrics_collector--ace_metrics_ensure"></a>`ace_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of Ace metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--ace_hosts"></a>`ace_hosts`

Data type: `Array[String]`

The list of ace hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the ace profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('ace_server')`

##### <a name="-puppet_metrics_collector--ace_port"></a>`ace_port`

Data type: `Integer`

Port to connect to ace on. Default: '44633'

Default value: `44633`

##### <a name="-puppet_metrics_collector--bolt_metrics_ensure"></a>`bolt_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of Bolt metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--bolt_hosts"></a>`bolt_hosts`

Data type: `Array[String]`

The list of bolt hosts to collect metrics from. Uses the hosts_with_pe_profile function to determine the list of hosts with the bolt profile.

Default value: `puppet_metrics_collector::hosts_with_pe_profile('bolt_server')`

##### <a name="-puppet_metrics_collector--bolt_port"></a>`bolt_port`

Data type: `Integer`

Port to connect to bolt on. Default: '62658'

Default value: `62658`

##### <a name="-puppet_metrics_collector--metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--activemq_metrics_ensure"></a>`activemq_metrics_ensure`

Data type: `String`



Default value: `'absent'`

##### <a name="-puppet_metrics_collector--activemq_hosts"></a>`activemq_hosts`

Data type: `Array[String]`



Default value: `[]`

##### <a name="-puppet_metrics_collector--activemq_port"></a>`activemq_port`

Data type: `Integer`



Default value: `8161`

##### <a name="-puppet_metrics_collector--puppetserver_excludes"></a>`puppetserver_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the puppetserver metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--puppetdb_excludes"></a>`puppetdb_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the puppetdb metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--orchestrator_excludes"></a>`orchestrator_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the orchestrator_excludes metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--console_excludes"></a>`console_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the console_excludes metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--ace_excludes"></a>`ace_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the ace_excludes metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--bolt_excludes"></a>`bolt_excludes`

Data type: `Optional[Array[String]]`

An Array of metrics to exclude from the bolt_excludes metrics collection.

Default value: `undef`

##### <a name="-puppet_metrics_collector--activemq_excludes"></a>`activemq_excludes`

Data type: `Optional[Array[String]]`

Collection of ActiveMQ metrics has been removed, but the parameters are left to avoid breaking upgrades

Default value: `undef`

##### <a name="-puppet_metrics_collector--metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`

The hostname of the metrics server to send data to. Default: undef

Default value: `undef`

##### <a name="-puppet_metrics_collector--metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`

(Deprecated) The port number of the metrics server to send data to. Default: undef

Default value: `undef`

### <a name="puppet_metrics_collector--system"></a>`puppet_metrics_collector::system`

This class manages collect postgres and system metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system` class:

* [`system_metrics_ensure`](#-puppet_metrics_collector--system--system_metrics_ensure)
* [`output_dir`](#-puppet_metrics_collector--system--output_dir)
* [`collection_frequency`](#-puppet_metrics_collector--system--collection_frequency)
* [`retention_days`](#-puppet_metrics_collector--system--retention_days)
* [`polling_frequency_seconds`](#-puppet_metrics_collector--system--polling_frequency_seconds)
* [`manage_sysstat`](#-puppet_metrics_collector--system--manage_sysstat)
* [`manage_vmware_tools`](#-puppet_metrics_collector--system--manage_vmware_tools)
* [`vmware_tools_pkg`](#-puppet_metrics_collector--system--vmware_tools_pkg)
* [`metrics_server_type`](#-puppet_metrics_collector--system--metrics_server_type)
* [`metrics_server_hostname`](#-puppet_metrics_collector--system--metrics_server_hostname)
* [`metrics_server_port`](#-puppet_metrics_collector--system--metrics_server_port)
* [`metrics_server_db_name`](#-puppet_metrics_collector--system--metrics_server_db_name)

##### <a name="-puppet_metrics_collector--system--system_metrics_ensure"></a>`system_metrics_ensure`

Data type: `String`

Whether to enable or disable the collection of System metrics. Valid values are 'present', and 'absent'. Default : 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--system--output_dir"></a>`output_dir`

Data type: `String`

The directory to write the metrics to. Default: '/opt/puppetlabs/puppet-metrics-collector'

Default value: `'/opt/puppetlabs/puppet-metrics-collector'`

##### <a name="-puppet_metrics_collector--system--collection_frequency"></a>`collection_frequency`

Data type: `Integer`

The frequency to collect metrics in minutes. Default: '5'

Default value: `5`

##### <a name="-puppet_metrics_collector--system--retention_days"></a>`retention_days`

Data type: `Integer`

The number of days to retain metrics. Default: '90'

Default value: `90`

##### <a name="-puppet_metrics_collector--system--polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `1`

##### <a name="-puppet_metrics_collector--system--manage_sysstat"></a>`manage_sysstat`

Data type: `Boolean`



Default value: `false`

##### <a name="-puppet_metrics_collector--system--manage_vmware_tools"></a>`manage_vmware_tools`

Data type: `Boolean`



Default value: `false`

##### <a name="-puppet_metrics_collector--system--vmware_tools_pkg"></a>`vmware_tools_pkg`

Data type: `String`



Default value: `'open-vm-tools'`

##### <a name="-puppet_metrics_collector--system--metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `getvar('puppet_metrics_collector::metrics_server_type')`

##### <a name="-puppet_metrics_collector--system--metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `getvar('puppet_metrics_collector::metrics_server_hostname')`

##### <a name="-puppet_metrics_collector--system--metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `getvar('puppet_metrics_collector::metrics_server_port')`

##### <a name="-puppet_metrics_collector--system--metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `getvar('puppet_metrics_collector::metrics_server_db_name')`

## Defined types

### <a name="puppet_metrics_collector--collect"></a>`puppet_metrics_collector::collect`

Creates systemd units for collecting a given metric

#### Parameters

The following parameters are available in the `puppet_metrics_collector::collect` defined type:

* [`ensure`](#-puppet_metrics_collector--collect--ensure)
* [`metrics_type`](#-puppet_metrics_collector--collect--metrics_type)
* [`metrics_command`](#-puppet_metrics_collector--collect--metrics_command)
* [`tidy_command`](#-puppet_metrics_collector--collect--tidy_command)
* [`env_vars`](#-puppet_metrics_collector--collect--env_vars)
* [`metric_ensure`](#-puppet_metrics_collector--collect--metric_ensure)
* [`minute`](#-puppet_metrics_collector--collect--minute)

##### <a name="-puppet_metrics_collector--collect--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`



Default value: `'present'`

##### <a name="-puppet_metrics_collector--collect--metrics_type"></a>`metrics_type`

Data type: `String`



Default value: `$title`

##### <a name="-puppet_metrics_collector--collect--metrics_command"></a>`metrics_command`

Data type: `String`



Default value: `undef`

##### <a name="-puppet_metrics_collector--collect--tidy_command"></a>`tidy_command`

Data type: `String`



Default value: `undef`

##### <a name="-puppet_metrics_collector--collect--env_vars"></a>`env_vars`

Data type: `Optional[Hash]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--collect--metric_ensure"></a>`metric_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="-puppet_metrics_collector--collect--minute"></a>`minute`

Data type: `String`



Default value: `'5'`

### <a name="puppet_metrics_collector--deprecated_parameter"></a>`puppet_metrics_collector::deprecated_parameter`

The puppet_metrics_collector::deprecated_parameter class.

### <a name="puppet_metrics_collector--pe_metric"></a>`puppet_metrics_collector::pe_metric`

A defined type to manage the configuration of tbe different metrics collection targets

#### Parameters

The following parameters are available in the `puppet_metrics_collector::pe_metric` defined type:

* [`metrics_type`](#-puppet_metrics_collector--pe_metric--metrics_type)
* [`metric_ensure`](#-puppet_metrics_collector--pe_metric--metric_ensure)
* [`cron_minute`](#-puppet_metrics_collector--pe_metric--cron_minute)
* [`retention_days`](#-puppet_metrics_collector--pe_metric--retention_days)
* [`hosts`](#-puppet_metrics_collector--pe_metric--hosts)
* [`metrics_port`](#-puppet_metrics_collector--pe_metric--metrics_port)
* [`metric_script_file`](#-puppet_metrics_collector--pe_metric--metric_script_file)
* [`ssl`](#-puppet_metrics_collector--pe_metric--ssl)
* [`excludes`](#-puppet_metrics_collector--pe_metric--excludes)
* [`additional_metrics`](#-puppet_metrics_collector--pe_metric--additional_metrics)
* [`override_metrics_command`](#-puppet_metrics_collector--pe_metric--override_metrics_command)
* [`metrics_server_type`](#-puppet_metrics_collector--pe_metric--metrics_server_type)
* [`env_vars`](#-puppet_metrics_collector--pe_metric--env_vars)

##### <a name="-puppet_metrics_collector--pe_metric--metrics_type"></a>`metrics_type`

Data type: `String`



Default value: `$title`

##### <a name="-puppet_metrics_collector--pe_metric--metric_ensure"></a>`metric_ensure`

Data type: `Enum['absent', 'present']`



Default value: `'present'`

##### <a name="-puppet_metrics_collector--pe_metric--cron_minute"></a>`cron_minute`

Data type: `String`



Default value: `'0/5'`

##### <a name="-puppet_metrics_collector--pe_metric--retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `90`

##### <a name="-puppet_metrics_collector--pe_metric--hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `['127.0.0.1']`

##### <a name="-puppet_metrics_collector--pe_metric--metrics_port"></a>`metrics_port`

Data type: `Integer`



Default value: `undef`

##### <a name="-puppet_metrics_collector--pe_metric--metric_script_file"></a>`metric_script_file`

Data type: `String`



Default value: `'tk_metrics'`

##### <a name="-puppet_metrics_collector--pe_metric--ssl"></a>`ssl`

Data type: `Boolean`



Default value: `true`

##### <a name="-puppet_metrics_collector--pe_metric--excludes"></a>`excludes`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::version_based_excludes($title)`

##### <a name="-puppet_metrics_collector--pe_metric--additional_metrics"></a>`additional_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="-puppet_metrics_collector--pe_metric--override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--pe_metric--metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['splunk_hec']]`



Default value: `undef`

##### <a name="-puppet_metrics_collector--pe_metric--env_vars"></a>`env_vars`

Data type: `Optional[Hash]`



Default value: `undef`

### <a name="puppet_metrics_collector--sar_metric"></a>`puppet_metrics_collector::sar_metric`

How often the target is requested to provide data, in seconds. Default: 1

#### Parameters

The following parameters are available in the `puppet_metrics_collector::sar_metric` defined type:

* [`collection_frequency`](#-puppet_metrics_collector--sar_metric--collection_frequency)
* [`retention_days`](#-puppet_metrics_collector--sar_metric--retention_days)
* [`polling_frequency_seconds`](#-puppet_metrics_collector--sar_metric--polling_frequency_seconds)
* [`cron_minute`](#-puppet_metrics_collector--sar_metric--cron_minute)
* [`metrics_type`](#-puppet_metrics_collector--sar_metric--metrics_type)
* [`metric_ensure`](#-puppet_metrics_collector--sar_metric--metric_ensure)
* [`metric_script_file`](#-puppet_metrics_collector--sar_metric--metric_script_file)
* [`metrics_shipping_command`](#-puppet_metrics_collector--sar_metric--metrics_shipping_command)
* [`env_vars`](#-puppet_metrics_collector--sar_metric--env_vars)

##### <a name="-puppet_metrics_collector--sar_metric--collection_frequency"></a>`collection_frequency`

Data type: `Integer`

The frequency to collect metrics in minutes. Default: '5'

Default value: `5`

##### <a name="-puppet_metrics_collector--sar_metric--retention_days"></a>`retention_days`

Data type: `Integer`

The number of days to retain metrics. Default: '90'

Default value: `90`

##### <a name="-puppet_metrics_collector--sar_metric--polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `1`

##### <a name="-puppet_metrics_collector--sar_metric--cron_minute"></a>`cron_minute`

Data type: `String`

The minute to run the cron job. Default: '0/5'

Default value: `'0/5'`

##### <a name="-puppet_metrics_collector--sar_metric--metrics_type"></a>`metrics_type`

Data type: `String`

The string aide to identify the metrics type,
this is used to create the metrics file name.

Default value: `$title`

##### <a name="-puppet_metrics_collector--sar_metric--metric_ensure"></a>`metric_ensure`

Data type: `Enum['absent', 'present']`

The ensure value for the metrics file. Default: 'present'

Default value: `'present'`

##### <a name="-puppet_metrics_collector--sar_metric--metric_script_file"></a>`metric_script_file`

Data type: `String`

The script file to run to collect the metrics. Default: 'system_metrics'

Default value: `'system_metrics'`

##### <a name="-puppet_metrics_collector--sar_metric--metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `String`

The parameter that defines the command for the remote shipping of metrics. Default: '$puppet_metrics_collector::system::metrics_shipping_command'

Default value: `$puppet_metrics_collector::system::metrics_shipping_command`

##### <a name="-puppet_metrics_collector--sar_metric--env_vars"></a>`env_vars`

Data type: `Optional[Hash]`



Default value: `undef`

## Functions

### <a name="puppet_metrics_collector--hosts_with_pe_profile"></a>`puppet_metrics_collector::hosts_with_pe_profile`

Type: Puppet Language

Function: hosts_with_pe_profile

Queries PuppetDB for hosts with the specified Puppet Enterprise profile.
Used by this module to query Puppet Enterprise API endpoints.
Parameters:

Results:

#### `puppet_metrics_collector::hosts_with_pe_profile(Any $profile)`

Function: hosts_with_pe_profile

Queries PuppetDB for hosts with the specified Puppet Enterprise profile.
Used by this module to query Puppet Enterprise API endpoints.
Parameters:

Results:

Returns: `Any` $hosts: an array of certnames. or ['127.0.0.1'] when PuppetDB returns no hosts.

##### `profile`

Data type: `Any`

the short name of the Puppet Enterprise profile.

### <a name="puppet_metrics_collector--to_yaml"></a>`puppet_metrics_collector::to_yaml`

Type: Ruby 4.x API

Description: Converts the content of the passed array or hash to YAML

#### `puppet_metrics_collector::to_yaml(Hash $hash_or_array)`

The puppet_metrics_collector::to_yaml function.

Returns: `String` YAML representation of the passed array or hash

##### `hash_or_array`

Data type: `Hash`



#### `puppet_metrics_collector::to_yaml(Array $hash_or_array)`

The puppet_metrics_collector::to_yaml function.

Returns: `String` YAML representation of the passed array or hash

##### `hash_or_array`

Data type: `Array`



### <a name="puppet_metrics_collector--version_based_excludes"></a>`puppet_metrics_collector::version_based_excludes`

Type: Puppet Language

Function: version_based_excludes

Description: Generates a list of services to exlude based on the metrics type

#### `puppet_metrics_collector::version_based_excludes(String[1] $metrics_type)`

Function: version_based_excludes

Description: Generates a list of services to exlude based on the metrics type

Returns: `Array[String]` excludes the list of services to exclude

##### `metrics_type`

Data type: `String[1]`

the service currently compiling metrics for

