module PuppetX
  module Util
    module String
      module Formatter
        DEFAULT_WIDTH = 80
        DEFAULT_COMM_WIDTH = 30
        DEFAULT_DESC_WIDTH = 50
        DEFAULT_INDENT = 4
        DEFAULT_TABLE_INDENT = 0
        def self.indent_level(n)
          4 + (n * 2)
        end

        def self.indent(str, indent=DEFAULT_INDENT)
          self.format(str, DEFAULT_WIDTH, indent)
        end

        def self.join_and_indent(array, indent=DEFAULT_INDENT, join_char="\n")
          self.format(array.join(join_char), DEFAULT_WIDTH, indent)
        end

        def self.wrap_no_indent(str, width=DEFAULT_WIDTH)
          self.format(str, width, 0)
        end

        def self.join_and_wrap_no_indent(array, width=DEFAULT_WIDTH, join_char="\n")
          self.format(array.join(join_char), width, 0)
        end

        def self.join_and_format(array, width=DEFAULT_WIDTH, indent=DEFAULT_INDENT, join_char="\n")
          self.format(array.join(join_char), width, indent)
        end

        def self.two_column_table(command_str, desc_str, comm_width=DEFAULT_COMM_WIDTH, desc_width=DEFAULT_DESC_WIDTH, indent=DEFAULT_INDENT)
          command = self.format(command_str)
          table_whitespace = " " * (comm_width - command.length)
          command = command + table_whitespace
          description = self.format(desc_str, desc_width, indent, command.length)
          return command + description
        end

        def self.format(str, width=DEFAULT_WIDTH, indent=DEFAULT_INDENT, table_indent=DEFAULT_TABLE_INDENT)
          all_lines = []
          col_indent = ' ' * table_indent
          if indent > 0
            indent_str = ' ' * indent
          else
            indent_str = ''
          end
          str.each_line do |line|
            lines = []
            current_line = ''
            line.split(/\s+/).each do |word|
              if current_line.empty?
                current_line = indent_str + word
              elsif current_line.size + word.size >= width
                lines << current_line
                current_line = indent_str + word
              else
                current_line << " " << word
              end
            end
            lines << current_line if current_line
            lines.each do |line|
              unless line == lines.first
                line = col_indent + line
              end
              all_lines << line
            end
          end

          return all_lines.join("\n")
        end

        # Strip ANSI color codes from the given string.
        # @return [String]
        def self.uncolorize(str)
          str.gsub(/\e\[([;\d]+)?m/, '')
        end
      end
    end
  end
end
