define puppet_enterprise::trapperkeeper::bootstrap_cfg (
  $namespace,
  $container,
  $service = $title,
  $order   = undef,
  $ensure  = present,
) {
  $path = "/etc/puppetlabs/${container}/bootstrap.cfg"
  $pe_container = "pe-${container}"

  $notify_full_restart = Exec["${pe_container} service full restart"]

  if ! defined(Pe_concat[$path]) {
    pe_concat { $path:
      notify => $notify_full_restart,
    }
  }

  if ($ensure == 'present') and !(defined(Pe_concat::Fragment["${container} ${service}"])) {
    pe_concat::fragment { "${container} ${service}":
      target  => $path,
      content => "${namespace}/${service}\n",
      order   => $order,
      notify  => $notify_full_restart,
      require => Package["pe-${container}"]
    }
  }
}
