# @api private
plan enterprise_tasks::standalone_pg_cert_regen(
  TargetSpec $primary,
  TargetSpec $external_pg,
) {
  enterprise_tasks::message('standalone_pg_cert_regen', 'Generating certs on standalone PE-PostgreSQL node...')
  run_task(enterprise_tasks::run_puppet, $external_pg)
  run_command("rm -f /opt/puppetlabs/puppet/cache/client_data/catalog/${external_pg}.json", $external_pg)
  run_task(enterprise_tasks::puppetserver_ca_clean, $primary, certname => $external_pg)
  run_task(enterprise_tasks::delete_cert, $external_pg, certname => $external_pg)
  run_task(enterprise_tasks::puppet_infra_configure, $external_pg)
}
