#!/opt/puppetlabs/puppet/bin/ruby

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'open3'

class WaitForService < EnterpriseTaskHelper
  def wait_interval
    5
  end

  def task(host:, service:, timeout:, **_kwargs)
    command = [
      '/opt/puppetlabs/bin/puppet-infrastructure',
      'status',
      '--host',
      host,
      '--service',
      service,
      '--format=json',
    ]

    start_time = Time.now
    stdout = nil
    command_status = nil
    command_exception = nil
    service_status = nil
    state = nil
    while (Time.now - start_time) < timeout
      begin
        stdout, _stderr, command_status = Open3.capture3(*command)
        service_status = JSON.parse(stdout)
        state = service_status.dig(0, 'state')
      rescue StandardError => e
        command_exception = e
      end
      break if state == 'running'
      sleep(wait_interval)
    end

    if state != 'running'
      raise EnterpriseTaskHelper::Error.new(
        "#{service} status not in running state within #{timeout} seconds on #{host}",
        'puppetlabs.wait-for-service/not-running',
        {
          puppet_infra_status_command: command.join,
          puppet_infra_status_output: stdout,
          puppet_infra_status_exitcode: command_status.exitstatus,
          exception: command_exception,
        }
      )
    end

    return service_status.to_json
  end
end

WaitForService.run if __FILE__ == $PROGRAM_NAME
