# Node Group Permissions

| Action (display name)                   | Definition |
| ---                                     | ---        |
| View                                    | The ability to see all attributes of a node group, most notably the values of class parameters and variables. This permission is inherited by all descendents of the node group.|
| Edit classes, parameters, and variables | The ability to edit every attribute of a node group except its environment and rule. This permission is inherited by all descendents of the node group.|
| Set environment                         | The ability to set the environment of a node group. This permission is inherited by all descendents of the node group.|
| Edit child group rules                  | The ability to edit the rules of descendents of a node group. Note that this does not grant the ability to edit the rules of the group in the `instance` field, only children of that group. This permission is inherited by all descendents of the node group.|
| Create, edit, & delete child groups     | The ability to create new child groups, delete existing child groups, and modify every attribute of child groups, including environment & rules. This permission is inherited by all descendents of the node group.|

Permissions of node groups will be inherited by all of their descendents.
This means that a user having a specific permission on a specific node group G will implicitly give them that same permission on any descendent node groups below G in the hierarchy.

As an example, if a user has the "Edit classes, parameters, and variables" permission on a node group called "Lucille", and the group "Michael" is a child of "Lucille", then the user will also have permission to edit the classes, parameters, and variables of the "Michael" group.
If the "Michael" group has a child named "George Michael", then the user will also have permission to edit the classes, parameters, and variables of the "George Michael" group, since it too is a descendent of "Lucille" and inherits all of its permissions.

It is worth noting that, since every node group has the default node group as an ancestor, if a user is given a permission on the default node group, this will be functionally equivalent to giving them that permission on "\*".

Permissions affecting the node group have two types: those affecting a group itself, and those affecting its child groups.
For instance, having the "Set Environment" permission on a group G will allow a user to set the environment
for group G *and* all of its children, while having "Edit child group rules" on group G will allow a user to edit the rules for any child group of G, but *not* for G itself.
This will allow users to set up permissions such that some users will be able to edit aspects of a group, while other users can be given permissions for all children of that group without being able to affect the group itself.

This capability is useful for restricting the nodes that a user has the ability to affect the classification of.
Because node groups inherit the rules of all their ancestors, a node group cannot match any node that their parent does not match.
This allows one to create a node group for, say, the "Amazing App" team's webserver nodes, that has a rule which only matches those nodes.
Then, child groups of that node could be created for a code-promotion workflow with three environments: "development", "staging", and "production".
Members of the "Amazing App" team could be given permission to "Edit Child Group Rules" and "Edit classes, parameters, and variables" on the parent group.
This allows the Amazing App team to decide which of their nodes should be in which environments, and change the classification of those nodes (either for all their nodes or for the nodes in a particular environment), but does not allow them to affect the classification of any other nodes, or put their nodes in environments other than
"development", "staging", or "production" (assuming that the parent group's environment is one of those three).

#### Node Group "Create, Edit, & Delete Child Groups" Permission

One thing that may not be obvious about the "Create, edit, & delete child groups" permission: when a group's parent is changed, it is semantically equivalent to a child being deleted from the perspective of the old parent, and a child being created from the perspective of the new parent.
Thus, moving groups between parents requires the "Create, edit, & delete child groups" permission on both the old parent and the new parent.

#### Node Group Permission Dependencies

There are two ways in which node group permissions depend on or replace one another.

First, in order to be able to use any of the node group permissions that start with "Edit" or "Set", the user must also have the ability to view that group.
If a user tries to edit a group they cannot view, the edit will be rejected and the user will receive a 403 Forbidden response.

Secondly, the "Create, edit, & delete child groups" permission implicitly grants all other node group permissions besides "View".
That is, if you have the "Create, edit, & delete child groups" permission on a group, then you can make any sort of legal edit to that group's children (and grandchildren, and great-grandchildren, etc.) as long as you can also view those children, even if you don't have any of the other edit permissions on those groups.
