# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Tasks

* [`init`](#init): Manage and inspect the state of packages
* [`linux`](#linux): Manage and inspect the state of packages (without a puppet agent)
* [`windows`](#windows): Manage the state of packages (without a puppet agent)

## Tasks

### <a name="init"></a>`init`

Manage and inspect the state of packages

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[install, status, uninstall, upgrade]`

The operation (install, status, uninstall and upgrade) to perform on the package.

##### `name`

Data type: `String[1]`

The name of the package to be manipulated.

##### `version`

Data type: `Optional[String[1]]`

Version numbers must match the full version to install, including release if the provider uses a release moniker. Ranges or semver patterns are not accepted except for the gem package provider. For example, to install the bash package from the rpm bash-4.1.2-29.el6.x86_64.rpm, use the string '4.1.2-29.el6'.

##### `manager_options`

Data type: `Optional[String[1]]`

options to be sent to the package manager

##### `provider`

Data type: `Optional[String[1]]`

The provider to use to manage or inspect the package, defaults to the system package manager. Only used when the 'puppet-agent' feature is available on the target so we can leverage Puppet.

### <a name="linux"></a>`linux`

Manage and inspect the state of packages (without a puppet agent)

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[install, status, uninstall, upgrade]`

The operation (install, status, uninstall and upgrade) to perform on the package.

##### `name`

Data type: `String[1]`

The name of the package to be manipulated.

##### `manager_options`

Data type: `Optional[String[1]]`

options to be sent to the package manager

##### `version`

Data type: `Optional[String[1]]`

Version numbers must match the full version to install, including release if the provider uses a release moniker. Ranges or semver patterns are not accepted except for the gem package provider. For example, to install the bash package from the rpm bash-4.1.2-29.el6.x86_64.rpm, use the string '4.1.2-29.el6'.

##### `provider`

Data type: `Optional[String[1]]`

The provider to use to manage or inspect the package, defaults to the system package manager. Only used when the 'puppet-agent' feature is available on the target so we can leverage Puppet.

### <a name="windows"></a>`windows`

Manage the state of packages (without a puppet agent)

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[install, uninstall, upgrade, status]`

The action to be applied to the package: install, uninstall, upgrade, and status.

##### `name`

Data type: `String[1]`

The name of the package to manage.

##### `version`

Data type: `Optional[String[1]]`

The version, and if applicable, the release value of the package. A version number range or a semver pattern are not permitted. For example, to install the bash-4.1.2-29.el6.x86_64.rpm package, enter 4.1.2-29.el6.

