# frozen_string_literal: true

require_relative '../../../puppet/file_serving/mount'

# Find files in the modules' pluginfacts directories.
# This is a very strange mount because it merges
# many directories into one.
class Puppet::FileServing::Mount::PluginFacts < Puppet::FileServing::Mount
  # Return an instance of the appropriate class.
  def find(relative_path, request)
    mod = parsed_env(request).modules.find { |m| m.pluginfact(relative_path) }
    return nil unless mod

    mod.pluginfact(relative_path)
  end

  def search(relative_path, request)
    env = parsed_env(request)
    # We currently only support one kind of search on plugins - return
    # them all.
    paths = parsed_env(request).modules.find_all(&:pluginfacts?).collect(&:plugin_fact_directory)
    if paths.empty?
      # If the modulepath is valid then we still need to return a valid root
      # directory for the search, but make sure nothing inside it is
      # returned.
      request.options[:recurse] = false
      env.modulepath.empty? ? [Puppet[:codedir]] : env.modulepath
    else
      paths
    end
  end

  def valid?
    true
  end
end
