require 'yaml'
require 'puppet/indirector/node/classifier'

Puppet::Functions.create_function(:classifier_data) do
  dispatch :classifier_data do
    param 'Any', :options
    param 'Puppet::LookupContext', :context
  end

  def classifier_data(options, context)
    node = closure_scope.compiler.node
    hard_coded_data = {'puppet_enterprise_classifier_data_backend_present' => true}
    adapted_node = Puppet::Node::HieraNodeAdapter.get(node)
    if adapted_node
      hiera_data = adapted_node.hiera_data || {}
      hiera_data = hard_coded_data.merge(hiera_data)
      context.cache_all(hiera_data)
      hiera_data
    else
      return hard_coded_data
    end
  end
end
