# pe\_installer: The Ruby Installer

This gem provided a prototype of installation and management support for Puppet
Enterprise using Bolt. This doc is here for historical purposes.

The principle tool that it provides is 'pe-admin'.

This repo is also used to store various Ruby scripts under the exe dir which in
older versions of PE were called by the puppet-enterprise-installer script to
perform more complex operations in Ruby.

## Installation

The gem is packaged as a component of the pe-installer package, managed by the
[pe-installer-vanagon](https://github.com/puppetlabs/pe-installer-vanagon)
project.

In addition to the gems listed in the Gemfile, the pe-admin tool has
dependencies on a puppet-runtime,
[enterprise_tasks](https://github.com/puppetlabs/enterprise_tasks), and
[puppet-enterprise-modules](https://github.com/puppetlabs/puppet-enterprise-modules)
which are provided by the package.

NOTE: this prototype relied on packaging changes in pe-installer which are no
longer present, on prototype classes in puppet-enterprise-modules, and on the
`enterprise_tasks` testing/install plans which should be removed in favor of
PEADM at this point.

## Usage

### pe-admin

The pe-admin tool is a Ruby CLI built with
[Thor](https://github.com/erikhuda/thor). It provides UI for interacting with
PE tarballs and executing management plans via Bolt. The plans are currently in
[enterprise_tasks/plans/testing](https://github.com/pupptlabs/enterprise_tasks).

The simplest way to work with the tool is probably to install the pe-installer
package from a PE tarball
([main/ci-ready](https://artifactory.delivery.puppetlabs.net/artifactory/generic_enterprise__local/main/ci-ready/)
for example), or otherwise obtain the package directly from artifactory
([main el8
rpms](https://artifactory.delivery.puppetlabs.net/artifactory/list/rpm_enterprise__local/main/repos/el-8-x86_64/)
for example).

To install the tool from a PE tarball, unpack the tarball and then run the
bootstrap-installer script that is part of the tarball.

The package installs into /opt/puppetlabs/installer, and the tool is runable
from /opt/puppetlabs/installer/bin/pe-admin.

For commandline help:

    /opt/puppetlabs/installer/bin/pe-admin help

#### Transport

The pe-admin tool is built on top of Bolt and makes use of the Bolt runtime
that is part of the pe-installer package. The install command uses ssh
transport to interact with the target nodes, unless you are running the
command on the primary that you are installing to, in which case local
transport is used. The local-install command always runs over local transport
on the same node.

#### Commands

##### install

    /opt/puppetlabs/installer/bin/pe-admin install --primary primary.net --tarball /some/pe-tarball.tar

Handles first time installation of Puppet Enterprise from the given tarball to
some set of PE nodes. This command can be used to orchestrate an entire PE
installation regardless of architecture (primary, database, compilers, replica,
see [Installing Pe](#installing-pe) below).

##### local-install

    /opt/puppetlabs/installer/bin/pe-admin local-install --pe-tarball-dir /some/unpacked/pe/tarball --pe-conf /some/pe.conf

This is an internal command (better names openly solicited).

Applies a puppet catalog on the local node to install packages and metadata
from the given PE tarball dir, and apply the correct `puppet_enterprise` profiles
based on the given pe.conf hiera configuration.

The command is only used to setup the core infrastructure nodes (primary, and
potentially database in the case of a legacy architecture).

This command is used internally during `pe-admin install` orchestration. It
only needs to be run manually in the case of a legacy install where ssh
is not available as transport.

##### upgrade

Upgrade an existing PE installation.

TBD

##### repair

Repair configuration of an existing PE installation.

TBD

##### validate

Validate that a given PE installation is in working order.

TBD

#### Installing PE

##### SSH (remote)

These cases assume you can use Bolt with SSH for transport to each of the
infrastructure nodes you're installing to.

We're also assuming that the workstation that we're installing from is not
itself the primary server. However, they can be the same node so long as the
primary can reach the rest of the infrastructure via SSH.

I expect it is more likely, though, that a customer will have a separate
workstation host that will have credentials to reach the infrastructure.

###### Standard

[(primary server, no compilers)](https://puppet.com/docs/pe/2021.7/supported_architectures.html#supported_architectures-standard-installation)

 1. Download the desired PE tarball onto your workstation
 2. Unpack it
 3. Run the bootstrap-installer script
 4. `/opt/puppetlabs/installer/bin/pe-admin install --primary primary.net --tarball /some/pe-tarball.tar`

This could/should be further automated if we make pe-installer available via
yum/apt.puppetlabs.com, just like puppet or bolt. Then the installer itself can
be installed/upgraded using yum or apt, and, if we implement a 'fetch' function,
it could pull down whatever PE tarball you wanted from pm.puppetlabs.com.

A customer then only needs a hole in their firewall to \*.puppetlabs.com to
make best use of the tool.

###### Large

[(primary server and compilers)](https://puppet.com/docs/pe/2021.7/supported_architectures.html#supported_architectures-large-installation)

 * add `--compilers compiler1.net,compiler2.net` to the pe-admin command

To properly configure a large installation, you need load balancers, which the
tool does not yet help you set up. If you already have load balancers, they can
be configured as documented
[here](https://puppet.com/docs/pe/2021.7/installing_compilers.html#using-load-balancers-with-compilers).

###### With HA

For the initial standard or large installation to include a replica:

 * add `--replicas replica.net` to the pe-admin command

The caveat here is that this assumes you first [set up code
manager](https://puppet.com/docs/pe/2021.7/code_mgr_config.html#configuring_code_manager).
The current plans install git and generate a local control-repository to manage
this for testing cases. Whether we want to make that an option for customers is
an open question.

The plans do have parameters for providing a control repo url
and private key, but they are not yet plumbed through in pe-admin, though you
could have them set in a pe.conf that you supply to pe-admin.

###### Legacy Standalone Postgresql

A legacy installation splits the core PE services between a primary and a
database node. This is the successor to the old legacy primary/puppetdb/console
split installation.

[(split primary and database with or without compilers)](https://puppet.com/docs/pe/2021.7/supported_architectures.html#supported_architectures-standalone-pe-postgres-installation)

 * add `--database database.net` to the pe-admin command

To install with compilers, add --compilers as mentioned in Large, above.

###### Extra Large (with HA, via peadm module)

TBD

[(extra large)](https://puppet.com/docs/pe/2021.7/supported_architectures.html#supported_architectures-xl-installation)

For an extra large with ha, you need to be using the
[peadm module](https://github.com/puppetlabs/puppetlabs-peadm) which hasn't
been incorporated into pe-admin yet.

This relies on a change to the structure of an extra-large installation such
that both the primary server and the database node have running pe-postgresql
services; the former with pglogical managed databases, and the later with just
the puppetdb database. This must be set up from scratch, or you need to
manually move the console/orchestrator databases back to the primary.

The peadm module also has support for setting up haproxy load balancers.

##### Local (no remote transport)

If the customer has made themselves so 'secure' that Bolt can't reach their
infrastructure, then they have to fall back to the older, more manual workflow
where they somehow get all the necessary files onto the node(s) and run the
local version of the install commands.

###### Standard

The steps are the same, just performed on the prospective primary server node itself.

###### Large

You would then need to manually generate agent nodes and provision them as
compilers.

###### Legacy Standalone Postgresql

As mentioned, a legacy installation splits out the database onto a
separate node. In this installation, the core PE infrastructure is now split
across both a primary and a database node and installation requires three
passes, once on the primary to set up the CA, once on the database to set up
postgresql, then again on the primary to finish configuring database dependent
services.

For this case, they have to place PE tarballs and pe.conf manually on both the
primary and the database node, just as they do with the current installation
process, and then run the local-install commands themselves since we can't
orchestrate the installation for them with Bolt.

 1. Place the tarball and a configured pe.conf file on the primary node
 2. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball --profile ca` on the primary
 3. Place the tarball and a configured pe.conf on the database node.
 4. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball` on the database
 5. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball` again on the primary
 6. Run puppet on the primary
 7. Run puppet on the database
 8. Run puppet again on the primary

These are the same basic steps that a user currently has to take for the
extra-large case, although with pe-admin, at least they aren't waiting for the
first install pass on the primary to fail.

Because they are running the local-install manually on both nodes, they are
also not getting the validation that the fully orchestrated `pe-admin install`
would normally provide customers.
