#!/opt/puppetlabs/installer/bin/ruby

$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_manager/lib'
$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_install/lib'

require 'puppet'
require 'puppet_x/util/classifier'
require 'puppet_x/util/classification'
require 'puppet_x/util/service_status'
require 'puppet/util/pe_node_groups'

UNCONVERTIBLE_FACTS = [
  'memoryfree_mb',
  'memorysize_mb',
  'swapfree_mb',
  'swapsize_mb',
  'blockdevices',
  'interfaces',
  'zones',
  'sshfp_dsa',
  'sshfp_ecdsa',
  'sshfp_ed25519',
  'sshfp_rsa',
  'zpool_featureflags',
  'zpool_featurenumbers',
  'zpool_version'
].freeze

Puppet.initialize_settings(['--libdir=/dev/null', '--factpath=/dev/null'])

begin
  nc = PuppetX::Util::Classification.get_node_classifier
  all_groups = PuppetX::Util::Classifier.get_groups(nc)
  # Get groups with a rule that includes a top level legacy fact that we are unable to convert automatically.
  # We need to do it this cumbersome way to sort out $::interfaces vs.  $facts['networking']['interfaces'], for example.
  bad_groups = all_groups.select do |group|
    if group['rule']
      facts = []
      group['rule'].flatten.each_with_index { |element, i| facts << group['rule'].flatten[i+1] if element == 'fact' }
      !(facts & UNCONVERTIBLE_FACTS).empty?
    else
      false
    end
  end
  bad_group_names = bad_groups.map { |group| group['name'] }
rescue Exception => e
  puts 'Error getting data from the classifier:'
  puts e
  exit 1
end

if bad_group_names.empty?
  exit 0
else
  # Remove : since we use it as the delimiter
  bad_group_names = bad_group_names.map { |g| g.gsub(':','_') }
  printf bad_group_names.join(':')
  exit 111
end
