#!/opt/puppetlabs/installer/bin/ruby
# Checks to ensure that your postgres node is current if you are attempting to update the master node.
$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_manager/lib/'
$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_infrastructure/lib/'

require 'puppet'
require 'puppet_x/puppetlabs/meep/configure/postgres'
require 'puppet_x/puppetlabs/meep/configure/psql'
require 'puppet_x/puppetlabs/meep/infra/lookup'
require 'puppet_x/puppetlabs/meep/infra/defaults'
Puppet.initialize_settings(['--libdir=/dev/null', '--factpath=/dev/null'])
include PuppetX::Puppetlabs::Meep::Infra::Lookup
include PuppetX::Puppetlabs::Meep::Infra::Defaults
include PuppetX::Puppetlabs::Meep::Configure::Postgres
FIPS = '/proc/sys/crypto/fips_enabled'

psql_opts = get_psql_options
psql = PuppetX::Puppetlabs::Meep::Configure::PSQL.new(psql_opts)
master = puppet_lookup('puppet_enterprise::puppet_master_host')
is_fips = File.exist?(FIPS) && File.read(FIPS).strip == '1'
if is_fips
    installed_postgres_version = infra_default(:CURRENT_FIPS_POSTGRES_VERSION)
else
    installed_postgres_version = infra_default(:CURRENT_POSTGRES_VERSION)
end
needs_update = psql.server_version !~ /^#{installed_postgres_version}/ && fqdn == master
exit 111 if !needs_update
