#!/opt/puppetlabs/installer/bin/ruby
#exec: get_classifier_value <GROUP> <CLASS> <PARAMETER>

$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_manager/lib'
$LOAD_PATH << '/opt/puppetlabs/server/data/environments/enterprise/modules/pe_install/lib'

require 'puppet'
require 'puppet_x/util/classifier'
require 'puppet_x/util/classification'
require 'puppet_x/util/service_status'
require 'puppet/util/pe_node_groups'

if ARGV.length != 3
  STDERR.puts "Script requires arguments: <GROUP> <CLASS> <PARAMETER>"
  exit
end

Puppet.initialize_settings(['--libdir=/dev/null', '--factpath=/dev/null'])

grp = ARGV[0]
cls = ARGV[1]
prm = ARGV[2]
value = ""

begin
  nc = PuppetX::Util::Classification.get_node_classifier
  all_groups = PuppetX::Util::Classifier.get_groups(nc)
  group = PuppetX::Util::Classifier.find_group(all_groups, grp)
rescue Exception => e
  puts 'Error getting data from the classifier:'
  puts e
  exit 1
end

unless group.nil? || 
    group['classes'].nil? || 
    group['classes'][cls].nil? || 
    group['classes'][cls][prm].nil?
  value = group['classes'][cls][prm]
end
puts value
